/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodCodeCoverageProfilingType.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 */
public class MethodCodeCoverageProfilingType implements IProfilingType {
	
	private MethodCodeCoverageUI _optionsUI;
	private Control control;
	private String description;
	
	public MethodCodeCoverageProfilingType()
	{
		_optionsUI = new MethodCodeCoverageUI();
	}
	
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config)
	{
		control =  _optionsUI.createControl(parent);
		initializeValues(config);
		
		return control;
	}

	protected void initializeValues(ProfilingSetsManagerCopy config)
	{
	}
	
	public Control getControl(String profilingSetName)
	{
		return control;
	}
	
	public ProfilingAttribute[] getAttributes()
	{
		//	map my UI options to options for the RAC
		//to be recognized as RAC options, the name should be prefixed by SETOPTION_	
		String prefix = "SETOPTION_";				
		
		List options = new ArrayList();

		String[][] flow = Options.OPTIONS_COVERAGE_NO_FLOW;
		for (int idx = 0; idx < flow.length; idx++) {
			options.add(new ProfilingAttribute(prefix+flow[idx][0], flow[idx][1]));
		}		
		
		ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
		options.toArray(pOptions);
		return pOptions;
	}
	
	/**
	 * Returns a not null error message is the current configuration is not valid
	 * This method is called when the current configuration is updated, for example when
	 * the user updates the profiling options for the current filter set 
	 * performApply is called next if this method returns a null value for all selected 
	 * profiling types
	 * 
	 * @param managerCopy a temporary copy for the current configuration
	 * @return null if the configuration is valid and can be applied
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy)
	{
		return null;
	}
	
	/**
	 * This method is called from the launch configuration, prior to launching the application
	 * If the method returns a not null string, an error message will be displayed and the
	 * launch configuration aborts
	 * @param config
	 * @return
	 */	
	public String launch(ILaunchConfiguration config)
	{
		return null;
	}
	
	public String getDescription(ProfilingSetsManagerCopy managerCopy)
	{
		return description;
	}
	
}
