/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodCodeCoverageUI.java,v 1.7 2005/08/09 02:48:50 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class MethodCodeCoverageUI {
		
	private Label titleLabel;
	private Label optionsLabel;
	
	public MethodCodeCoverageUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		result.setLayout(layout);
		result.setLayoutData(data);
		
		titleLabel = new Label(result, SWT.NULL);
		titleLabel.setText(UIPlugin.getResourceString("coverageType"));
		titleLabel.setLayoutData(GridUtil.createHorizontalFill());

		Font font = titleLabel.getFont();
		if (font != null) {
			FontData[] fonts = font.getFontData();
			if (fonts != null && fonts.length >= 1) {
				titleLabel.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
			}
		}
		
		new Label(result, SWT.NULL);
		
		optionsLabel = new Label(result, SWT.WRAP);
		optionsLabel.setText(TraceMessages.AN_COV);
		data = new GridData();
		data.horizontalIndent = 20;
		data.widthHint = 375;
		optionsLabel.setLayoutData(data);
		return result;
	}
}
