/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileDetailItem.java,v 1.5 2006/05/11 15:05:05 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/ 

package org.eclipse.hyades.trace.ui.internal.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

/**
 * A profile detail item that appears under every TRCAgentProxy object in the
 * Profiling Monitor navigator if it has profiling details. 
 * The items will contain the same
 * content as their parent.
 */
public class ProfileDetailItem implements INavigatorItem {
	
	private static Image _image;
	private Object _parent;
	private String _name;
	private String _type;
	private URL _url;
	private ImageDescriptor _imageDescriptor;
	private AnalysisType _analysisType;
	
	public ProfileDetailItem(Object parent, String name, String type, URL myURL) {
		_parent = parent;
		_name = name;
		_type = type;
		_url = myURL;
	}
	
	
	/**
	 * Ali M. -- Overloaded the constructor of this class to accept image descriptors
	 * in place of URLs.
	 * 
	 * @param parent The parent of this detail item
	 * @param nameTypePair A string array of size 2, where nameTypePair[0] = name & nameTypePair[1] = type
	 * @param imageDescriptor The image descriptor of the icon associated with this item
	 * @param analysisType Points to the analysis type that this navigator item represents
	 */
	public ProfileDetailItem(Object parent, String[] nameTypePair, ImageDescriptor imageDescriptor, AnalysisType analysisType) {
		_parent = parent;
		_name = nameTypePair[0];
		_type = nameTypePair[1];
		_imageDescriptor = imageDescriptor;
		_analysisType = analysisType;
	}

	/*
	 * The navigator looks for IAdaptables that have
	 * IWorkbenchAdapters. If present, they are used for
	 * content. 
	 */
	public Object getAdapter(Class adapter) {
		if (IWorkbenchAdapter.class.equals(adapter)) {
			return new WorkbenchAdapter() {
				public Object[] getChildren(Object object) {
					return ProfileDetailItem.this.getChildren().toArray();
				}
				public ImageDescriptor getImageDescriptor(Object object) {
					return ProfileDetailItem.this.getImageDescriptor();
				}
				public String getLabel(Object object) {
					return ProfileDetailItem.this.getText();
				}
				public Object getParent(Object object) {
					return ProfileDetailItem.this.getParent();
				}
			};
		}
		else {
			return null;
		}
	}
	
	// no children
	public List getChildren() {
		return new ArrayList();
	}
	
	// repeat the parent's data
	public Object getData() 
	{
		return _parent;		
	}
	
	public boolean isAnalysisType ()
	{
		return _analysisType != null;
	}
	
	public AnalysisType getAnalysisType ()
	{
		return _analysisType;
	}
	
	public Image getImage() {		
		if (_url != null) 
		{
			if (_image == null) 
			{
				_image = getImageDescriptor().createImage();
				Display.getDefault().addListener(SWT.Dispose, new Listener() 
				{
					public void handleEvent(Event event) 
					{
						_image.dispose();
					}
				});
			}
			return _image;
		}
		
		if (_imageDescriptor != null)
		{
			return _imageDescriptor.createImage();
		}
		
		return null;
	}

	private ImageDescriptor getImageDescriptor() {
		if (_url != null) 
		{
			return ImageDescriptor.createFromURL(_url);
		}
		
		if (_imageDescriptor != null)
		{
			return _imageDescriptor;
		}
		return null;
	}
	
	public Object getParent() {
		return _parent;
	}

	// the text displayed in the label
	public String getText() {
		return _name;
	}
	
	public String getType() {
		return _type;
	}
	
	// no children
	public boolean hasChildren() {
		return false;
	}
	
	public boolean isDeleteEnabled() {
		return false;
	}
	
	// non-persistent; can't be saved
	public boolean isSaveEnabled() {
		return false;
	}
	
	public boolean isUnloadEnabled() {
		return false;
	}
	
	// not enabled
	public void delete(boolean referentialIntegrity, boolean deleteContents) {
	}

	// not enabled
	public void save(boolean referentialIntegrity) {
	}
	
	// not enabled
	public void unload(boolean referentialIntegrity) {
	}
}

