/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PIAttachListener.java,v 1.3 2005/06/27 15:53:11 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.piclient;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.swt.widgets.Display;


public class PIAttachListener extends PIProcessListener
{   
  /**
 * PIProcessListener constructor comment.
 */
public PIAttachListener(TRCNode node)
{
	super(node);
}
public PIAttachListener(TRCNode node, TRCProcessProxy process)
{
	super(node, process);
}

public synchronized void agentActive(Agent ag)
{
	if(fProcess == null)
	  return;
    if(_monitoredAgents.contains(ag.getName()))
        _monitor = false; 
    else
    	_monitoredAgents.add(ag.getName());    	        
    if(!_monitor)
      return;

	TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(fProcess,ag,true);
	
	if(agentProxy == null)
	  return;

	/* set the runtime UUID of the agent */
	agentProxy.setRuntimeId(ag.getUUID());
	agentProxy.setActive(true);
	agentProxy.setAttached(true);
	agentProxy.setProfileFile(ag.getProfileFile());
		
//	agent.setAgentInstance(ag);
	LoadersUtils.registerAgentInstance(agentProxy,ag);

	giveControl(agentProxy, true, true);
	
	final TRCAgentProxy agentTemp = agentProxy;
	Display.getDefault().asyncExec(new Runnable() {
	public void run()
	{
		//update ui
		ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
		event.setSource(agentTemp);
		event.setType(ProfileEvent.START_MONITOR);
		UIPlugin.getDefault().notifyProfileEventListener(event);	            
	}});
	giveControl(agentProxy, false, true);
	
}
}
