/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceBasePreferencePage.java,v 1.10 2008/03/11 18:47:27 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceOptionsUI;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID tbpp0000 for Profiling preference page
*/

/*
 * The page for setting java plugin preferences.
 */
public class TraceBasePreferencePage extends PreferencePage
									 implements IWorkbenchPreferencePage
{
	// Constants		
	private TraceOptionsUI _options;

	public TraceBasePreferencePage()
	{
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
		
	}
	protected Control createContents(Composite parent)
	{
		Composite composite= new Composite(parent, SWT.NONE);	
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
		parent,
		UIPlugin.getPluginId()+".tbpp0000");
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 5;	
		layout.numColumns= 1;		
		composite.setLayout(layout);
		
		_options = new TraceOptionsUI(this);
		_options.createControl(composite);
		
		Dialog.applyDialogFont( composite );

		return composite;
	}
/**
 * Returns preference store that belongs to the our plugin.
 * This is important because we want to store
 * our preferences separately from the desktop.
 *
 * @return the preference store for this plugin
 */
protected IPreferenceStore doGetPreferenceStore() {
	return UIPlugin.getDefault().getPreferenceStore();
}
	public void init(IWorkbench workbench) {
	}
/**
 * Initializes states of the controls using default values
 * in the preference store.
 */
private void initializeDefaults()
{
	IPreferenceStore store = getPreferenceStore();

	_options.setInfoMsgOption(store.getDefaultBoolean(TraceConstants.PROFILE_TIPS));
	_options.setReloadMsgOption(store.getDefaultBoolean(CommonUITraceConstants.RELOAD_INFO));
	_options.setProjectName(store.getDefaultString(CommonUITraceConstants.TRACE_PROJECT_NAME));
	/* Navid Mehregani - bugzilla_158635: The SAVE_ON_EXIT_KEY option should be read and stored in the preference store of CommonUITracePlugin */
	_options.setSaveOnExitOption(CommonUITracePlugin.getDefault().getPreferenceStore().getDefaultString(CommonUITraceConstants.SAVE_ON_EXIT_KEY));
	_options.setSwitchPerspOption(CommonUIPlugin.getDefault().getPreferenceStore().getDefaultString(HyadesUI.SWITCH_TO_PERSPECTIVE_KEY));
	_options.setRefreshType(store.getDefaultInt(TraceConstants.REFRESH_TYPE), store.getDefaultInt(TraceConstants.REFRESH_INTERVAL));

}
/**
 * Does anything necessary because the default button has been pressed.
 */
protected void performDefaults() {
	super.performDefaults();
	initializeDefaults();
}
/**
 * Do anything necessary because the OK button has been pressed.
 *
 * @return whether it is okay to close the preference page
 */
public boolean performOk() {
	storeValues();
	UIPlugin.getDefault().savePluginPreferences();
	return true;
}
/**
 * Stores the values of the controls back to the preference store.
 */
private void storeValues()
{
	IPreferenceStore store = getPreferenceStore();
	
	store.setValue(CommonUITraceConstants.TRACE_PROJECT_NAME, _options.getProjectName());	
	store.setValue(TraceConstants.PROFILE_TIPS, _options.getInfoMsgOption());	
	store.setValue(CommonUITraceConstants.RELOAD_INFO, _options.getReloadMsgOption());
	/* Navid Mehregani - bugzilla_158635: The SAVE_ON_EXIT_KEY option should be read and stored in the preference store of CommonUITracePlugin */
	CommonUITracePlugin.getDefault().getPreferenceStore().setValue(CommonUITraceConstants.SAVE_ON_EXIT_KEY, _options.getSaveOnExitOption());
	CommonUIPlugin.getDefault().getPreferenceStore().setValue(HyadesUI.SWITCH_TO_PERSPECTIVE_KEY, _options.getSwitchPerspOption());

   store.setValue(TraceConstants.REFRESH_TYPE, _options.getRefreshType());
   store.setValue(TraceConstants.REFRESH_INTERVAL, _options.getRefreshInterval());	
}
}
