/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceViewPreferencePage.java,v 1.8 2007/04/05 04:17:12 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import java.util.Set;

import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceViewOptionsUI;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID tvpp0000 for Monitors View preference page
 */

/*
 * The page for setting java plugin preferences.
 */
public class TraceViewPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {
	private TraceViewOptionsUI _options;

	public TraceViewPreferencePage() {
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());

	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
				UIPlugin.getPluginId() + ".tvpp0000");

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new TraceViewOptionsUI();
		_options.createControl(composite);
		
		Dialog.applyDialogFont( composite );

		return composite;
	}

	/**
	 * Returns preference store that belongs to the our plugin. This is
	 * important because we want to store our preferences separately from the
	 * desktop.
	 * 
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return UIPlugin.getDefault().getPreferenceStore();
	}

	public void init(IWorkbench workbench) {
	}

	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		store.setValue(CommonUITraceConstants.DISPLAY_PROJECTS, false);
		_options.initializeValues();
	}

	/**
	 * Do anything necessary because the OK button has been pressed.
	 * 
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		UIPlugin.getDefault().savePluginPreferences();
		return true;
	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		// Perform the update
		_options.storeValues();

		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		
		if(store.getInt(TraceConstants.PROFILING_MONITOR_LAYOUT) == CommonUITraceConstants.LAYOUT_FLAT
				|| store.getInt(CommonUITraceConstants.LOGN_LAYOUT) == CommonUITraceConstants.LAYOUT_FLAT)
			return;
		
		// reset filters on all trace views
		final IWorkbenchWindow window = UIPlugin.getActiveWorkbenchWindow();
		if (window == null)
			return;

		IWorkbenchPage[] persps = window.getPages();
		for (int idx = 0; idx < persps.length; idx++) {
			if (persps[idx].getPerspective().getId().equals(
					PDPerspective.ID_TRACE_PERSPECTIVE)) {// trace perspective
				IWorkbenchPage page = persps[idx];

				if(store.getInt(TraceConstants.PROFILING_MONITOR_LAYOUT) != CommonUITraceConstants.LAYOUT_FLAT)				
					updateView(PDPerspective.ID_PD_NAVIGATOR_VIEW, page);
				if(store.getInt(CommonUITraceConstants.LOGN_LAYOUT) != CommonUITraceConstants.LAYOUT_FLAT)								
					updateView(PDPerspective.ID_LOG_NAVIGATOR_VIEW, page);
			}
		}

	}

	private void updateView(String id, IWorkbenchPage page) {
		final IViewPart view = page.findView(id);
		if (view != null) {
			BusyIndicator.showWhile(Display.getDefault(), new Runnable() {
				public void run() {
					// First get the expanded state of the tree
					Navigator viewer = (Navigator) view;
					Tree tree = ((TreeViewer) viewer.getViewer()).getTree();
					Set visible = UIUtil
							.getVisibleViewerNodes((TreeViewer) viewer
									.getViewer());
					tree.setRedraw(false);

					// viewer.updateActionBars();
					viewer.getViewer().refresh();

					// Reset the expanded state of the tree
					UIUtil.setVisibleViewerNodes((TreeViewer) viewer
							.getViewer(), visible);
					tree.setRedraw(true);
				}
			});

		}
	}
}
