/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CSVTraceStatReportWizard.java,v 1.7 2008/12/12 22:21:58 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
package org.eclipse.hyades.trace.ui.internal.reports;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

import com.ibm.icu.util.ULocale;

/**
 *
 */
public class CSVTraceStatReportWizard extends HTMLTraceStatReportWizard {
		
	public CSVTraceStatReportWizard() {
		super();
        setWindowTitle(TraceMessages._18); //$NON-NLS-1$
        
        FILE_EXTENSION = "csv";
	}

	/**
     * @see org.eclipse.hyades.ui.report.ReportGeneratorWizard#generate(org.eclipse.core.runtime.IProgressMonitor)
     */
    public IFile generate(IProgressMonitor monitor) throws Exception {
    	
    	Object sel = getSelection().getFirstElement();
    	if(sel == null || !(sel instanceof IExportViewer))
    		return null;
      
        monitor.beginTask("", 4); //$NON-NLS-1$             
    	
        IFile reportFile = getReportFile();
        if (reportFile.exists()) {
            if (!MessageDialog.openQuestion(getShell(), CommonUIMessages._158, //$NON-NLS-1$
            		CommonUIMessages._159)) //$NON-NLS-1$
                return null;
        }
        
        monitor.worked(1);
        export((IExportViewer)sel, reportFile.getLocation().toOSString());
        monitor.worked(1);

        reportFile.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
        monitor.done();
           
        return reportFile;
    }
	
	/**
     * 
     * @param viewer
     * @return
     */
	protected boolean export(IExportViewer viewer, String fileName) {
		
		if(fileName == null)
		{
			MessageDialog.openError(getShell(), TraceMessages.TRC_MSGT, TraceMessages._6);
		    return false;
		}
		
		Writer writer = null;
		try {
			File file = new File(fileName);
			if(file.isDirectory())
			{
				MessageDialog.openError(getShell(), TraceMessages.TRC_MSGT, TraceMessages._7);
				return false;				
			}
			OutputStream outputStream = new FileOutputStream(file.toString(), false);
			ULocale locale = ULocale.getDefault();
			String encoding = "UTF8";
			
			if (locale.getLanguage() == ULocale.JAPANESE.getLanguage()) {
				encoding = "MS932";
			}
			else if (locale.getLanguage() == ULocale.KOREAN.getLanguage()) {
				encoding = "MS949";
			}
			else if (locale.getLanguage() == ULocale.CHINESE.getLanguage()) {
				if (locale.getCountry() == ULocale.TRADITIONAL_CHINESE.getCountry()) {
						encoding = "MS950_HKSCS";	
				}
				else if (locale.getCountry() == ULocale.SIMPLIFIED_CHINESE.getCountry()) {
					encoding = "MS936";
				}
			}
			
			if (!System.getProperty("os.name").startsWith("Windows") //$NON-NLS-1$ //$NON-NLS-2$          
					&& !encoding.equals("UTF8"))
			{
				encoding = "UTF8";
			}

			//only windows machines is affected
			writer = new OutputStreamWriter(outputStream, encoding);

		} catch (IOException ioException) {
			ioException.printStackTrace();			
			return false;
		}
		
		StringBuffer buffer = new StringBuffer();        
		buffer.append(getCSVFormat(viewer.getViewerTitle()));
		
		for(int idx=0; idx<viewer.getViewerControls().length; idx++)
		{
			if(viewer.getViewerControls()[idx] instanceof Tree)
				buffer.append(printColumns((Tree)viewer.getViewerControls()[idx]));
		}
		
		try {
			writer.write(buffer.toString());
			writer.flush();
			writer.close();
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		
		return true;
	}
    
	protected String printColumns(Tree tree)
	{		
		StringBuffer buffer = new StringBuffer();

		buffer.append(newLine);
		for (int idx = 0; idx < tree.getColumnCount(); idx++) {

			if(idx > 0)
				buffer.append(",");
			
			buffer.append(getCSVFormat(tree.getColumn(idx).getText()));
		}

		printTreeItems(tree.getItems(), 0, buffer, tree.getColumnCount());

		return buffer.toString();
	}
	
	protected void printTreeItems(TreeItem[] treeItems, int level, StringBuffer buffer, int columnCount)
	{
		for (int kdx = 0; kdx < treeItems.length; kdx++)
		{
			buffer.append(newLine);
	
			for (int ndx = 0; ndx < columnCount; ndx++)
			{				
				if(ndx>0)
					buffer.append(",");
								
				StringBuffer bf = new StringBuffer(ndx==0?getFirstColumnIndentString(treeItems[kdx], level):"")
						.append(getCSVFormat(treeItems[kdx].getText(ndx)));
				
				buffer.append(getCSVFormat(bf.toString()));
				
			}

			if (treeItems[kdx].getExpanded())
				printTreeItems(treeItems[kdx].getItems(), level+1, buffer, columnCount);
		}
	}
	
	protected String getFirstColumnIndentString(TreeItem item, int level)
	{
		StringBuffer buffer = new StringBuffer();
		
		for (int i = 0; i < level; i ++)
			buffer.append("    ");
			
		buffer.append("    ");
		
		return buffer.toString();
	}    
	
}
