/* ***********************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLTraceReportWizard.java,v 1.10 2010/11/01 15:07:18 mreid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
package org.eclipse.hyades.trace.ui.internal.reports;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

/**
 *
 */
public class XMLTraceReportWizard extends HTMLTraceReportWizard {

	
	public XMLTraceReportWizard() {
		super();
        setWindowTitle(TraceMessages._20); //$NON-NLS-1$
        
        FILE_EXTENSION = "xml";       
	}

	protected void generateAgentStatistics(List agentList, StringBuffer buffer) {
		
		for(int idx=0; idx<agentList.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy)agentList.get(idx);
			
			buffer.append(newLine).append("<Agent name=\"").append(replaceEntities(agent.getName())).append("\"")
			 .append(" type=\"").append(agent.getType()).append("\"")
			 .append(" runtimeId=\"").append(agent.getRuntimeId()).append("\"")
			 .append(" startTime=\"").append(agent.getStartTime()).append("\"")
			 .append(" stopTime=\"").append(agent.getStopTime()).append("\"")
 			 .append(" collectionMode=\"").append(agent.getCollectionMode()).append("\"")
			.append(">");
			
			generateStatistics(agent, buffer);
			
			 buffer.append(newLine).append("</Agent>");
			
		}
		
	}
	
	protected void generateStatistics(TRCAgentProxy agent, StringBuffer buffer) {
		
		TRCProcess proc = PerftraceUtil.getProcess(agent.getAgent());
		if(proc != null)
		{
			buffer.append(newLine).append("<process pid=\"").append(proc.getPid()).append("\"")
		    .append(" id=\"").append(proc.getId()).append("\"")
		    .append(" startTime=\"").append(proc.getStartTime()).append("\"")
		    .append(" lastEventTime=\"").append(proc.getStopTime()).append("\"")
		    .append(" baseTime=\"").append(proc.getBaseTime()).append("\"")
		    .append(" cumulativeTime=\"").append(proc.getCumulativeTime()).append("\"")
		    .append(" calls=\"").append(proc.getCalls()).append("\"")
		    .append(" totalSize=\"").append(proc.getTotalSize()).append("\"")
		    .append(" totalInstances=\"").append(proc.getTotalInstances()).append("\"");
		    if (proc.getClassClass() != null)
		    	buffer.append(" classClass=\"").append(proc.getClassClass().getId()).append("\"");
		    buffer.append("/>");
			
		}
		
		Object[] threads = PerftraceUtil.getAllThreads(agent);
		for(int idx=0; idx<threads.length;idx++)
		{
			TRCThread thread = (TRCThread)threads[idx];
			
			buffer.append(newLine).append("<threads name=\"").append(thread.getName()).append("\"")
			    .append(" id=\"").append(thread.getId()).append("\"")
			    .append(" startTime=\"").append(thread.getStartTime()).append("\"")
			    .append(" stopTime=\"").append(thread.getStopTime()).append("\"")
			    .append(" maxStackDepth=\"").append(thread.getMaxStackDepth()).append("\"")
			    .append("/>");
		}
		
		Object[] packages = PerftraceUtil.getAllPackages(agent);
		
		for(int idx=0; idx<packages.length;idx++)
		{
			TRCPackage pack = (TRCPackage)packages[idx];
			
			buffer.append(newLine).append("<packages name=\"").append(pack.getName()).append("\"")
			    .append(" baseTime=\"").append(pack.getBaseTime()).append("\"")
			    .append(" cumulativeTime=\"").append(pack.getCumulativeTime()).append("\"")
			    .append(" calls=\"").append(pack.getCalls()).append("\"")
			    .append(" totalSize=\"").append(pack.getTotalSize()).append("\"")
			    .append(" totalInstances=\"").append(pack.getTotalInstances()).append("\"")
			    .append(" collectedSize=\"").append(pack.getCollectedSize()).append("\"")
			    .append(" collectedInstances=\"").append(pack.getCollectedInstances()).append("\"")			    
			    .append(">");
			
			generateClassStatistics(pack, buffer);
			
			buffer.append(newLine).append("</packages>");						
		}
	}

	protected void generateClassStatistics(TRCPackage pack, StringBuffer buffer) {
		
		Iterator classes = pack.getClasses().iterator();
		
		while(classes.hasNext())
		{
			TRCClass cls = (TRCClass)classes.next();
			
			buffer.append(newLine).append("    <classes name=\"").append(replaceEntities(cls.getName())).append("\"")
		    .append(" id=\"").append(cls.getId()).append("\"")
		    .append(" loadTime=\"").append(cls.getLoadTime()).append("\"")			
		    .append(" baseTime=\"").append(cls.getBaseTime()).append("\"")
		    .append(" cumulativeTime=\"").append(cls.getCumulativeTime()).append("\"")
		    .append(" calls=\"").append(cls.getCalls()).append("\"")
		    .append(" totalSize=\"").append(cls.getTotalSize()).append("\"")
		    .append(" totalInstances=\"").append(cls.getTotalInstances()).append("\"")
		    .append(" collectedSize=\"").append(cls.getCollectedSize()).append("\"")
		    .append(" collectedInstances=\"").append(cls.getCollectedInstances()).append("\"")		
		    .append(" loadedBy=\"").append(cls.getLoadedBy()==null?"null":cls.getLoadedBy().getId()).append("\""); //bug 274430
	
		    if(cls.getSourceInfo() != null)
		    		buffer.append(" sourceInfo=\"").append(cls.getSourceInfo().getLocation()).append("\"");
		    
			Iterator iterator = cls.getClassObjects().iterator();
			if(iterator.hasNext())
			{
			    buffer.append(" classObjects=\"");				
				while(iterator.hasNext())
				{
					buffer.append(((TRCObject)iterator.next()).getId()).append(" ");
				}	    		
				buffer.append("\"");
			}
			buffer.append(">");
		    
			generateMethodStatistics(cls, buffer);
		
   		    buffer.append(newLine).append("    </classes>");						
			
		}
	}

	protected void generateMethodStatistics(TRCClass cls, StringBuffer buffer) {
		Iterator methods = cls.getMethods().iterator();

		while(methods.hasNext())
		{
			TRCMethod meth = (TRCMethod)methods.next();
			
			buffer.append(newLine).append("      <methods name=\"").append(replaceEntities(meth.getName())).append("\"")
		    .append(" id=\"").append(meth.getId()).append("\"")
		    .append(" signature=\"").append(meth.getSignature()).append("\"")			
		    .append(" baseTime=\"").append(meth.getBaseTime()).append("\"")
		    .append(" cumulativeTime=\"").append(meth.getCumulativeTime()).append("\"")
		    .append(" calls=\"").append(meth.getCalls()).append("\"")
		    .append("/>");
		}

	}

	protected String printHeader()
	{
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(newLine)
		   .append("<Contents ");
				
		return buffer.toString();
	}
	
	protected String printFooter()
	{
		StringBuffer buffer = new StringBuffer();		
		buffer.append(newLine).append("</Contents>").append(newLine);
		return buffer.toString();
	}
	
	protected String printTitle(String title)
	{
		StringBuffer buffer = new StringBuffer();
		
		buffer.append(" name=\"").append(replaceEntities(title)).append("\">");
        return buffer.toString();		
	}
	
}
