/* ***********************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLTraceStatReportWizard.java,v 1.6 2007/03/01 15:58:56 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/
package org.eclipse.hyades.trace.ui.internal.reports;


import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/**
 *
 */
public class XMLTraceStatReportWizard extends HTMLTraceStatReportWizard {

	public XMLTraceStatReportWizard() {
		super();
        setWindowTitle(TraceMessages._19); //$NON-NLS-1$
        
        FILE_EXTENSION = "xml";        
	}

	protected String printHeader()
	{
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(newLine)
		   .append("<View");
				
		return buffer.toString();
	}
	
	protected String printTitle(String title)
	{
		StringBuffer buffer = new StringBuffer();
		
		buffer.append(" name=\"").append(replaceEntities(title)).append("\">").append(newLine);
        return buffer.toString();		
	}
	
	protected String printFooter()
	{
		final String newLine = System.getProperties().getProperty("line.separator");
		
		StringBuffer buffer = new StringBuffer();		
		buffer.append("</View>").append(newLine);
		return buffer.toString();
	}
	
	protected String printColumns(Tree tree)
	{		
		StringBuffer buffer = new StringBuffer();
		
		String[] names = new String[tree.getColumnCount()];
		for (int idx = 0; idx < tree.getColumnCount(); idx++) {
			
			String columnText = tree.getColumn(idx).getText();

			if (columnText.indexOf("<") == 0 || columnText.indexOf(">") == 0)
				columnText = columnText.substring(1);			
			
			names[idx]= getValidAttributeName(columnText);
		}		
		
		TreeItem[] items = tree.getItems();
		printTreeColumns(names, items, 0, buffer);
		
		return buffer.toString();		
	}

	protected void printTreeColumns(String[] names, TreeItem[] items, int level, StringBuffer buffer) {
		for(int idx=0; idx<items.length; idx++)
		{		
			for(int j=0;j<level; j++)
				buffer.append("  ");
			
			buffer.append("<data");
			
			for(int i=0; i<names.length; i++)
			{
				if(names[i] == null || names[i].length() == 0)
					continue;
								
				buffer.append(" ").append(replaceEntities(names[i])).append("=\"").append(replaceEntities(items[idx].getText(i)))
				  .append("\"");
			}
			
			if (items[idx].getExpanded())
			{
				buffer.append(">").append(newLine);				
				printTreeColumns(names, items[idx].getItems(), level+1, buffer);
				for(int j=0;j<level; j++)
					buffer.append("  ");				
				buffer.append("</data>").append(newLine);				
			}
			else
				buffer.append("/>").append(newLine);								
			
		}
		
	}

	private String getValidAttributeName(String columnText) {
				
		if(columnText == null)
			return null;
		
		columnText = columnText.replace(' ', '_');
		columnText = columnText.replace(')', '.');
		columnText = columnText.replace('(', '.');
		//bugzilla 149500, XML attribute name doesn't allow to use "%".
		columnText = columnText.replaceAll("%", "Percentage");
		
		return columnText;
	}
    
}
