/*******************************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

/**
 * Contains the configuration detail required to attach to a set of agents
 * 
 * @author Ali Mehregani
 */
public class AttachConfigurationDetail
{
	/** The host name where the agents reside */
	private String hostName;
	
	/** The AC port number on the hostName that the agents reside */ 
	private String portNumber;
	
	/** The agents to attach to */
	private Vector agents;
	
	/** The options to use for the attach */
	private Vector options;
	
	/** The filters to use for the attach */
	private ArrayList filters;
	
	/** The project to use for the attach */
	private String project;
	
	/** The monitor to use for the attach */
	private String monitor;
	
	/** The profile name to use for the attach */
	private String profileFile;
	
	/** The launch */
	private ILaunch launch;
	
	/** Indicates whether the perspective should be changed */
	private boolean switchPerspective;

	/** Indicates whether the agent configuration should be forced to be clread */
	private boolean forceAgentConfClear;
	
	
	/**
	 * The default constructor.  Setter methods are expected to be used to set the
	 * required fields.
	 */
	public AttachConfigurationDetail()
	{
		
	}
	
	
	/**
	 * Construct an instance of this class based on a launch configuration
	 *  
	 * @param configuration The launch configuration
	 * @param launch The launch
	 */
	public AttachConfigurationDetail(ILaunchConfiguration configuration, ILaunch launch)
	{
		try
		{
			IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
			IPreferenceStore tStore = CommonUITracePlugin.getDefault().getPreferenceStore();
			this.hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, CommonUITraceConstants.LOCAL_HOST);
			this.portNumber = String.valueOf(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(CommonUIConstants.LOCALHOST_PORT)));
			this.project = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, tStore.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));
			this.monitor = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, tStore.getString(CommonUITraceConstants.TRACE_MONITOR_NAME));
			this.launch = launch;
			if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				this.profileFile = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
			else
				this.profileFile = (String)null; 
			
		} 
		catch (CoreException e)
		{
			UIPlugin.getDefault().log(e);
		}
	}

	/**
	 * This can be a mixture of types IAgent and Agent.  The client is expected to handle
	 * both types.
	 * 
	 * @return the agents
	 */
	public Vector getAgents()
	{
		return agents;
	}

	/**
	 * This can be a mixture of types IAgent and Agent
	 * 
	 * @param agents the agents to set
	 */
	public void setAgents(Vector agents)
	{
		this.agents = agents;
	}

	/**
	 * @return the filters
	 */
	public ArrayList getFilters()
	{
		return filters;
	}

	/**
	 * @param filters the filters to set
	 */
	public void setFilters(ArrayList filters)
	{
		this.filters = filters;
	}

	/**
	 * @return the hostName
	 */
	public String getHostName()
	{
		return hostName;
	}

	/**
	 * @param hostName the hostName to set
	 */
	public void setHostName(String hostName)
	{
		this.hostName = hostName;
	}

	/**
	 * @return the launch
	 */
	public ILaunch getLaunch()
	{
		return launch;
	}

	/**
	 * @param launch the launch to set
	 */
	public void setLaunch(ILaunch launch)
	{
		this.launch = launch;
	}

	/**
	 * @return the monitor
	 */
	public String getMonitor()
	{
		return monitor;
	}

	/**
	 * @param monitor the monitor to set
	 */
	public void setMonitor(String monitor)
	{
		this.monitor = monitor;
	}

	/**
	 * @return the options
	 */
	public Vector getOptions()
	{
		return options;
	}

	/**
	 * @param options the options to set
	 */
	public void setOptions(Vector options)
	{
		this.options = options;
	}

	/**
	 * @return the portNumber
	 */
	public String getPortNumber()
	{
		return portNumber;
	}

	/**
	 * @param portNumber the portNumber to set
	 */
	public void setPortNumber(String portNumber)
	{
		this.portNumber = portNumber;
	}

	/**
	 * @return the profileFile
	 */
	public String getProfileFile()
	{
		return profileFile;
	}

	/**
	 * @param profileFile the profileFile to set
	 */
	public void setProfileFile(String profileFile)
	{
		this.profileFile = profileFile;
	}

	/**
	 * @return the project
	 */
	public String getProject()
	{
		return project;
	}

	/**
	 * @param project the project to set
	 */
	public void setProject(String project)
	{
		this.project = project;
	}

	/**
	 * @return the switchPerspective
	 */
	public boolean isSwitchPerspective()
	{
		return switchPerspective;
	}

	/**
	 * @param switchPerspective the switchPerspective to set
	 */
	public void setSwitchPerspective(boolean switchPerspective)
	{
		this.switchPerspective = switchPerspective;
	}

	/**
	 * @return the forceAgentConfClear
	 */
	public boolean isForceAgentConfClear()
	{
		return forceAgentConfClear;
	}

	/**
	 * @param forceAgentConfClear the forceAgentConfClear to set
	 */
	public void setForceAgentConfClear(boolean forceAgentConfClear)
	{
		this.forceAgentConfClear = forceAgentConfClear;
	}
	
	
}
