/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AttachInfoDialog.java,v 1.5 2005/08/09 02:48:49 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AttachInfoDialog extends Dialog implements SelectionListener {

	private java.lang.String _title;
	private Button _showAgain;

	public AttachInfoDialog(Shell shell, String windowTitle) {
		super(shell);
		_title = windowTitle;
	}


	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}

	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 2;
		result.setLayout(layout);
		data = GridUtil.createFill();
		result.setLayoutData(data);

		Image image = Display.getCurrent().getSystemImage(SWT.ICON_INFORMATION);//JFaceResources.getImageRegistry().get(DLG_IMG_INFO);
		if (image != null) {
			Label label = new Label(result, 0);
			image.setBackground(label.getBackground());
			label.setImage(image);
			label.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_CENTER |
				GridData.VERTICAL_ALIGN_BEGINNING));
		}


		Label infoMessage = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 3;
		infoMessage.setLayoutData(data);

		infoMessage.setText(TraceMessages.AT_INFOM);
		
		infoMessage = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		infoMessage.setLayoutData(data);

		_showAgain = new Button(result,SWT.CHECK);
		data = GridUtil.createHorizontalFill();
		//data.horizontalAlignment = GridData.END;
		data.horizontalSpan = 3;
		_showAgain.setLayoutData(data);
		
		_showAgain.setText(TraceMessages.AT_MSGCB);
		_showAgain.addSelectionListener(this);		

		return result;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == _showAgain)
		{
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
			store.setValue(TraceConstants.PROFILE_TIPS, !_showAgain.getSelection());
		}
	}
}
