/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class BasicTraceFeatureFilterAttribute extends BasicFeatureFilterAttribute {
	private String _attributeId;
	private String _context;

	public BasicTraceFeatureFilterAttribute(String id, String attributeId, EStructuralFeature feature, RelationalOperators[] operators, boolean useNotLikeOperator) {
		super(id, null, feature, operators, useNotLikeOperator);
		
		_attributeId = attributeId;
	}
	
	public void setContext(String context)
	{
		_context = context; 
	}
	
	public String attributeId() {
		return _attributeId;
	}
	
	public String displayText() {
		IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider(_context, _attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
		if (clfp!=null)
			return clfp.getDisplayStringFromElement(_attributeId,null,IContextLabelFormatProvider.MODE_VIEW_FILTER);
		else
			return _attributeId;

	}
	
	/**
	 * Returns the value from the given entered display value
	 */	
	protected String getValueFromDisplayValue(String value)
	{
		IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider(_context, _attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
		if (clfp!=null)
			return clfp.convertDisplayStringToModelValue(value);
		else
			return value;
	}

	
	/**
	 * Returns the display value from the given value.
	 */		
	protected String getDisplayValue(String value)
	{
		IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider(_context, _attributeId, IContextLabelFormatProvider.MODE_VIEW_FILTER);
		if (clfp!=null)
			return clfp.convertModelValueToDisplayString(value);
		else
			return value;
	}
}
