/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterTableElement.java,v 1.6 2010/08/22 22:10:13 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

/**
 * An element with differently typed properties. Changing a property sends out a
 * DomainEvent.
 */
public class FilterTableElement {
	public static final String P_VISIBILITY = "combo";
	public static final String P_TEXT = "string";
	public static final String P_METHOD = "method";

	private String fText;
	private String fMethod = "*";
	private String fVisibility;

	protected static final String[] fVisibilityState = new String[] { TraceMessages.EXCLUDE, TraceMessages.INCLUDE };

	private FilterList fParent;

	/**
	 * Initialize a new TestElement from the given data.
	 */

	private boolean strEqual(String a, String b) {
		if (a == b) {
			return true;
		}

		if (a != b) {
			return false;
		}

		// necessarily neither a nor b are null at this point.
		return a.equals(b);

	}

	@Override
	public boolean equals(Object o) {

		if (!(o instanceof FilterTableElement)) {
			return false;
		}
		FilterTableElement f = (FilterTableElement) o;

		if (!strEqual(f.getMethod(), this.getMethod()))
			return false;

		if (!strEqual(f.getVisibility(), this.getVisibility()))
			return false;

		if (!strEqual(f.getText(), this.getText()))
			return false;

		return true;

	}

	public FilterTableElement(String text, String method, String visibility) {
		fMethod = method;
		fText = text;
		fVisibility = visibility;
	}

	public void setParent(FilterList parent) {
		fParent = parent;
	}

	public String getMethod() {

		return fMethod;
	}

	public String getText() {
		return fText;
	}

	public String getVisibility() {
		return fVisibility;
	}

	/**
	 * Insert the method's description here. Creation date: (1/8/2001 3:11:58
	 * PM)
	 * 
	 * @return int
	 */
	public int getVisibilityState() {
		for (int idx = 0; idx < fVisibilityState.length; idx++) {
			if (fVisibilityState[idx].equals(fVisibility))
				return idx;
		}

		return -1;
	}

	/**
	 * Insert the method's description here. Creation date: (1/8/2001 3:11:26
	 * PM)
	 * 
	 * @return java.lang.Object[]
	 */
	public static String[] getVisibilityStates() {
		return fVisibilityState;
	}

	public void setMethod(String value) {
		fMethod = value;
		fParent.fireElementChanged(this, P_METHOD);
	}

	public void setText(String value) {
		fText = value;

		fParent.fireElementChanged(this, P_TEXT);
	}

	public void setVisibility(int value) {
		fVisibility = fVisibilityState[value];

		fParent.fireElementChanged(this, P_VISIBILITY);
	}

	public void setVisibility(String value) {
		fVisibility = value;

		if (fParent != null)
			fParent.fireElementChanged(this, P_VISIBILITY);
	}

	public String toString() {
		return (fText + "," + fVisibility);
	}
}
