/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PerftraceUtil.java,v 1.11 2008/11/18 20:58:18 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;

import com.ibm.icu.text.NumberFormat;


public class PerftraceUtil {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static NumberFormat _decimalFormat = null; 
    private static NumberFormat _percentFormat = null;
    private static ArrayList tmpList = new ArrayList();

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     */
    public static int getActiveInstances(EObject mofObject) {
        int inst = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        inst = (proces.getTotalInstances() - proces.getCollectedInstances());
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                                }
                            }
                        }
                    }
                }
            }
        }

        return inst;
    }

    /**
     *
     */
    public static long getActiveSize(EObject mofObject) {
        long size = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        size = proces.getTotalSize() - proces.getCollectedSize();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            size += (proces.getTotalSize() - proces.getCollectedSize());
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                size += (proces.getTotalSize() - proces.getCollectedSize());
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    size += (proces.getTotalSize() - proces.getCollectedSize());
                                }
                            }
                        }
                    }
                }
            }
        }

        return size;
    }

    /**
     *
     */
    public static Object[] getAllClasses(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentClasses((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentClasses((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentClasses((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentClasses((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllGc(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentGc((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentGc((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentGc((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentGc((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static Object[] getAllHeapDump(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentHeapDump((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentHeapDump((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentHeapDump((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentHeapDump((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllPackages(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentPackages((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentPackages((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentPackages((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentPackages((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllReferences(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentObjReferences((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentObjReferences((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentObjReferences((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentObjReferences((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static Object[] getAllThreads(EObject mofObject) {
    	return getAllThreads(mofObject, true);
    }
    
    
    public static Object[] getAllThreads(EObject mofObject, boolean withInvocations) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentThreads((TRCAgentProxy) mofObject, tmpList, withInvocations);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentThreads((TRCAgentProxy) agents[idx], tmpList, withInvocations);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentThreads((TRCAgentProxy) agents[i], tmpList, withInvocations);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentThreads((TRCAgentProxy) agents[i], tmpList, withInvocations);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static TRCClass getClass(TRCMethodInvocation invocation) {
        TRCObject o = invocation.getOwningObject();

        if (o!=null && o.getIsA() != invocation.getProcess().getClassClass()) {
            return o.getIsA();
        } else {
            return invocation.getMethod().getDefiningClass();
        }
    }

    /**
     *
     * @param object
     * @return the class for the object
     */
    public static TRCClass getClass(TRCObject object) {
        TRCClass clas = object.getIsA();

        if (clas == object.getProcess().getClassClass()) { //is a class object, try to get the class name associated with it

            TRCPackage[] packages = (TRCPackage[]) object.getProcess().getPackages().toArray();

            for (int i = 0; i < packages.length; i++) {
                TRCClass[] classes = (TRCClass[]) packages[i].getClasses().toArray();

                for (int j = 0; j < classes.length; j++) {
                    Object[] objects = classes[j].getClassObjects().toArray();

                    for (int k = 0; k < objects.length; k++) {
                        if (objects[k] == object) {
                            return classes[j];
                        }
                    }
                }
            }
        }

        return clas;
    }

    /**
     *
     */
    public static double getMaximumTime(EObject mofObject) {
        double time = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        time = proces.getLastEventTime();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            double tmp = proces.getLastEventTime();

                            if (tmp > time) {
                                time = tmp;
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                double tmp = proces.getLastEventTime();

                                if (tmp > time) {
                                    time = tmp;
                                }
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    double tmp = proces.getLastEventTime();

                                    if (tmp > time) {
                                        time = tmp;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return time;
    }

    /**
     *
     */
    public static String getPackageName(TRCPackage pack, Object mofObject) {
        StringBuffer buff = new StringBuffer(pack.getName());

        if (buff.length() == 0) {
            buff.append(TraceMessages._17);
        }

        if (mofObject instanceof TRCAgentProxy || mofObject instanceof TRCProcessProxy) {
            return buff.toString();
        }

        return buff.append(" [").append(pack.getProcess().getPid()).append("]").toString();
    }

    public static TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }

        return null;
    }

    /**
     *
     */
    public static String getThreadName(TRCThread thread) {
        StringBuffer tmpBuffer = new StringBuffer(thread.getName());

        return tmpBuffer.append("[").append(thread.getProcess().getPid()).append("]").toString();
    }

    /**
     *
     */
    public static long getTime(double etime) {
        return (long) (etime * 1000000);
    }

    /**
     *
     */
    public static int getTotalCalls(EObject mofObject) {
        int calls = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        calls = proces.getCalls();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            calls += proces.getCalls();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                calls += proces.getCalls();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    calls += proces.getCalls();
                                }
                            }
                        }
                    }
                }
            }
        }

        return calls;
    }

    /**
     *
     */
    public static int getTotalInstances(EObject mofObject) {
        int inst = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        inst = proces.getTotalInstances();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            inst += proces.getTotalInstances();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                inst += proces.getTotalInstances();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    inst += proces.getTotalInstances();
                                }
                            }
                        }
                    }
                }
            }
        }

        return inst;
    }
/*
 * This method was added for bugzilla 147893, to calculate the
 * total collected instances to be used in the Memory Statistics view
 * calculation of the percentage of collected instances
 */
    public static int getTotalCollectedInstances(EObject mofObject) {
        int inst = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        inst = proces.getCollectedInstances();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            inst += proces.getCollectedInstances();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                inst += proces.getCollectedInstances();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    inst += proces.getCollectedInstances();
                                }
                            }
                        }
                    }
                }
            }
        }

        return inst;
    }
    
    public static long getTotalSize(EObject mofObject) {
        long size = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                    if (proces != null) {
                        size = proces.getTotalSize();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                        if (proces != null) {
                            size += proces.getTotalSize();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                            if (proces != null) {
                                size += proces.getTotalSize();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                                if (proces != null) {
                                    size += proces.getTotalSize();
                                }
                            }
                        }
                    }
                }
            }
        }

        return size;
    }

    public static boolean collectInstanceInformation(TRCAgentProxy agent) {
        if (agent.getName().equals(CommonUIConstants.J2EE_AGENT_NAME)) {
            return true;
        }

        TRCCollectionMode type = agent.getCollectionMode();

        if ((type == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL) || (type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (type == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL)) {
            return false;
        }

        Iterator configs = agent.getConfigurations().iterator();

        if (configs.hasNext()) {
            TRCConfiguration config = (TRCConfiguration) configs.next();
            EList options = config.getOptions();

            if (options != null) {
                Iterator i = options.iterator();

                while (i.hasNext()) {
                    TRCOption option = (TRCOption) i.next();

                    if (option.getKey().equals(Options.OPTION_TRACE_MODE)) {
                        if (option.getValue().equals(Options.OPTION_VALUE_NOOBJECTCORRELATION)) {
                            return false;
                        }
                    }
                }
            }
        }

        return true;
    }

    /**
     *
     */
    public static boolean collectStatisticInfo(EObject mofObject) {
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCAgentProxy agent = (TRCAgentProxy) mofObject;

				return  (agent.getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (agent.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
					boolean collectStatistic = (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);

                    if (!collectStatistic) {
                        return false;
                    }
                }
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        boolean collectStatistic = (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);

                        if (!collectStatistic) {
                            return false;
                        }
                    }
                }
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            boolean collectStatistic = (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);

                            if (!collectStatistic) {
                                return false;
                            }
                        }
                    }
                }
            }
        }

        return true;
    }

    public static String formatAsPercentage(double d) {
        if (_percentFormat == null) {
            _percentFormat = NumberFormat.getPercentInstance();
            _percentFormat.setMaximumIntegerDigits(3);
            _percentFormat.setMaximumFractionDigits(2);
            _percentFormat.setMinimumFractionDigits(2);
        }

        return _percentFormat.format(d);
    }

    public static String formatTimeValue(double d) {
        return formatTimeValue(d, true);
    }
    
    public static String formatTimeValueWithoutGrouping(double d) {
        return formatTimeValue(d, false);
    }
    
    public static String formatTimeValue(double d, boolean groupingUsed) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumFractionDigits(6);
            _decimalFormat.setMinimumFractionDigits(6);
            _decimalFormat.setGroupingUsed(groupingUsed);
        }

        return _decimalFormat.format(d);
    }

    private static void getAgentClasses(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        Object[] packages = getProcess(agent.getAgent()).getPackages().toArray();

        for (int idx = 0; idx < packages.length; idx++) {
            list.addAll(((TRCPackage) packages[idx]).getClasses());
        }
    }

    private static void getAgentGc(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        //list.addAll(getProcess(agent).getGarbageCollector());  
    }

    private static void getAgentHeapDump(TRCAgentProxy agent, ArrayList list) {
    	TRCProcess proces = getProcess(agent.getAgent());
    	
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (proces == null)) {
            return;
        }

        list.addAll(proces.getHeapDumps());
    }

    private static void getAgentObjReferences(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        /*
           Object[] heapdump = agent.getProcess().getHeapDump().toArray();
           if(heapdump.length > 0)
           {
                   TRCHeapDumpEvent heapEvent = (TRCHeapDumpEvent)heapdump[heapdump.length-1];
                   list.addAll(heapEvent.getReference());
           }
         */
    }

    private static void getAgentPackages(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        list.addAll(getProcess(agent.getAgent()).getPackages());
    }

    private static void getAgentThreads(TRCAgentProxy agent, ArrayList list, boolean withInvocations) {
    	TRCProcess proces = getProcess(agent.getAgent());    	
    	
        if (!agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) || (proces == null)) {
            return;
        }

        Object[] threads = proces.getThreads().toArray();

        for (int idx = 0; idx < threads.length; idx++) {
            TRCThread thread = (TRCThread) threads[idx];

            if (thread.getInitialInvocations().size() > 0
            		|| !withInvocations) {
                if (thread.getName() == null) {
                    thread.setName(String.valueOf(idx + 1));
                }

                list.add(thread);
            }
        }
    }

    /**
     * @return
     */
    private static Object[] getObjectArray() {
        Object[] ret = tmpList.toArray();

        tmpList.clear();

        return ret;
    }
    
    
    /**
    *
    */
   public static double getMaximumCumulativeTime(EObject mofObject) {
       double time = 0;

       if (mofObject != null) {
           if (mofObject instanceof TRCAgentProxy) {
               if (((TRCAgentProxy) mofObject).getAgent() != null) {
                   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

                   if (proces != null) {
                       time = proces.getCumulativeTime();
                   }
               }
           } else if (mofObject instanceof TRCProcessProxy) {
               Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

               for (int idx = 0; idx < agents.length; idx++) {
                   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                       TRCProcess proces = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

                       if (proces != null) {
                           double tmp = proces.getCumulativeTime();

                           if (tmp > time) {
                               time = tmp;
                           }
                       }
                   }
               }
           } else if (mofObject instanceof TRCNode) {
               Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

               for (int idx = 0; idx < processes.length; idx++) {
                   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                   for (int i = 0; i < agents.length; i++) {
                       if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                           TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                           if (proces != null) {
                               double tmp = proces.getCumulativeTime();

                               if (tmp > time) {
                                   time = tmp;
                               }
                           }
                       }
                   }
               }
           } else if (mofObject instanceof TRCMonitor) {
               Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

               for (int k = 0; k < nodes.length; k++) {
                   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                   for (int idx = 0; idx < processes.length; idx++) {
                       Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                       for (int i = 0; i < agents.length; i++) {
                           if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                               TRCProcess proces = getProcess(((TRCAgentProxy) agents[i]).getAgent());

                               if (proces != null) {
                                   double tmp = proces.getCumulativeTime();

                                   if (tmp > time) {
                                       time = tmp;
                                   }
                               }
                           }
                       }
                   }
               }
           }
       }

       return time;
   }
   
   public static double getProcessPackageCumulativeTime(TRCProcess process) {
	   double time = 0;
	   Object [] packages = process.getPackages().toArray();
	   for(int pkg = 0; pkg < packages.length; pkg++) {
		   if(packages[pkg] != null)
			   time += ((TRCPackage)packages[pkg]).getCumulativeTime();
	   }
	   return time;
   }
   
   public static double getTotalPackagesCumulativeTime(EObject mofObject) {
	   if (mofObject == null) {
		   return 0;
	   }
	   
	   double result = 0;
	   if (mofObject instanceof TRCAgentProxy) {
		   if (((TRCAgentProxy) mofObject).getAgent() != null) {
			   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

			   if (proces != null) {
				   result = getProcessPackageCumulativeTime(proces);
			   }
		   }
	   } else if (mofObject instanceof TRCProcessProxy) {
		   Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

		   for (int idx = 0; idx < agents.length; idx++) {
			   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				   TRCProcess process = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

				   if (process != null) {
					   result += getProcessPackageCumulativeTime(process);
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCNode) {
		   Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

		   for (int idx = 0; idx < processes.length; idx++) {
			   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

			   for (int i = 0; i < agents.length; i++) {
				   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

					   if (process != null) {
						   result += getProcessPackageCumulativeTime(process);
					   }
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCMonitor) {
		   Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

		   for (int k = 0; k < nodes.length; k++) {
			   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

			   for (int idx = 0; idx < processes.length; idx++) {
				   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				   for (int i = 0; i < agents.length; i++) {
					   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

						   if (process != null) {
							   result += getProcessPackageCumulativeTime(process);
						   }
					   }
				   }
			   }
		   }
	   }

	   return result;
   }
   
   public static double getTotalBaseTime(EObject mofObject) {
	   if (mofObject == null) {
		   return 0;
	   }
	   
	   double result = 0;
	   if (mofObject instanceof TRCAgentProxy) {
		   if (((TRCAgentProxy) mofObject).getAgent() != null) {
			   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

			   if (proces != null) {
				   result = proces.getBaseTime();
			   }
		   }
	   } else if (mofObject instanceof TRCProcessProxy) {
		   Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

		   for (int idx = 0; idx < agents.length; idx++) {
			   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				   TRCProcess process = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

				   if (process != null) {
					   result += process.getBaseTime();
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCNode) {
		   Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

		   for (int idx = 0; idx < processes.length; idx++) {
			   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

			   for (int i = 0; i < agents.length; i++) {
				   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

					   if (process != null) {
						   result += process.getBaseTime();
					   }
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCMonitor) {
		   Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

		   for (int k = 0; k < nodes.length; k++) {
			   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

			   for (int idx = 0; idx < processes.length; idx++) {
				   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				   for (int i = 0; i < agents.length; i++) {
					   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

						   if (process != null) {
							   result += process.getBaseTime();
						   }
					   }
				   }
			   }
		   }
	   }

	   return result;
   }
   
   public static double getTotalInheritedBaseTime(EObject mofObject) {
	   if (mofObject == null) {
		   return 0;
	   }
	   
	   double result = 0;
	   if (mofObject instanceof TRCAgentProxy) {
		   if (((TRCAgentProxy) mofObject).getAgent() != null) {
			   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

			   if (proces != null) {
				   result = proces.getInheritedBaseTime();
			   }
		   }
	   } else if (mofObject instanceof TRCProcessProxy) {
		   Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

		   for (int idx = 0; idx < agents.length; idx++) {
			   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				   TRCProcess process = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

				   if (process != null) {
					   result += process.getInheritedBaseTime();
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCNode) {
		   Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

		   for (int idx = 0; idx < processes.length; idx++) {
			   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

			   for (int i = 0; i < agents.length; i++) {
				   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

					   if (process != null) {
						   result += process.getInheritedBaseTime();
					   }
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCMonitor) {
		   Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

		   for (int k = 0; k < nodes.length; k++) {
			   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

			   for (int idx = 0; idx < processes.length; idx++) {
				   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				   for (int i = 0; i < agents.length; i++) {
					   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

						   if (process != null) {
							   result += process.getInheritedBaseTime();
						   }
					   }
				   }
			   }
		   }
	   }

	   return result;
   }
   
   public static double getTotalInheritedCumulativeTime(EObject mofObject) {
	   if (mofObject == null) {
		   return 0;
	   }
	   
	   double result = 0;
	   if (mofObject instanceof TRCAgentProxy) {
		   if (((TRCAgentProxy) mofObject).getAgent() != null) {
			   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

			   if (proces != null) {
				   result = proces.getInheritedCumulativeTime();
			   }
		   }
	   } else if (mofObject instanceof TRCProcessProxy) {
		   Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

		   for (int idx = 0; idx < agents.length; idx++) {
			   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				   TRCProcess process = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

				   if (process != null) {
					   result += process.getInheritedCumulativeTime();
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCNode) {
		   Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

		   for (int idx = 0; idx < processes.length; idx++) {
			   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

			   for (int i = 0; i < agents.length; i++) {
				   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

					   if (process != null) {
						   result += process.getInheritedCumulativeTime();
					   }
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCMonitor) {
		   Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

		   for (int k = 0; k < nodes.length; k++) {
			   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

			   for (int idx = 0; idx < processes.length; idx++) {
				   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				   for (int i = 0; i < agents.length; i++) {
					   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

						   if (process != null) {
							   result += process.getInheritedCumulativeTime();
						   }
					   }
				   }
			   }
		   }
	   }

	   return result;
   }

   /**
    *
    */
   public static double getTotalCumulativeTime(EObject mofObject) {
	   if (mofObject == null) {
		   return 0;
	   }
	   
	   double result = 0;
	   if (mofObject instanceof TRCAgentProxy) {
		   if (((TRCAgentProxy) mofObject).getAgent() != null) {
			   TRCProcess proces = getProcess(((TRCAgentProxy) mofObject).getAgent());

			   if (proces != null) {
				   result = proces.getCumulativeTime();
			   }
		   }
	   } else if (mofObject instanceof TRCProcessProxy) {
		   Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

		   for (int idx = 0; idx < agents.length; idx++) {
			   if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				   TRCProcess process = getProcess(((TRCAgentProxy) agents[idx]).getAgent());

				   if (process != null) {
					   result += process.getCumulativeTime();
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCNode) {
		   Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

		   for (int idx = 0; idx < processes.length; idx++) {
			   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

			   for (int i = 0; i < agents.length; i++) {
				   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

					   if (process != null) {
						   result += process.getCumulativeTime();
					   }
				   }
			   }
		   }
	   } else if (mofObject instanceof TRCMonitor) {
		   Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

		   for (int k = 0; k < nodes.length; k++) {
			   Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

			   for (int idx = 0; idx < processes.length; idx++) {
				   Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				   for (int i = 0; i < agents.length; i++) {
					   if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						   TRCProcess process = getProcess(((TRCAgentProxy) agents[i]).getAgent());

						   if (process != null) {
							   result += process.getCumulativeTime();
						   }
					   }
				   }
			   }
		   }
	   }

	   return result;
   }

   public static boolean hasMethodInvocationInfo(final EObject object) {
		TRCAgentProxy agentProxy = getAgentProxy(object);
		if(agentProxy == null){
			return false;
		}		
		TRCCollectionMode mode = agentProxy.getCollectionMode();

		return (mode == TRCCollectionMode.EXECUTION_FULL_LITERAL
				|| mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL
				|| mode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL)
				|| hasOptionSet(agentProxy, Options.OPTION_CPU_TIME, Boolean.TRUE)
				&& (mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
	}

   public static boolean hasFullMethodInvocationInfo(final EObject object) {
	   TRCAgentProxy agentProxy = getAgentProxy(object);
	   if(agentProxy == null){
		   return false;
	   }	   
	   TRCCollectionMode mode = agentProxy.getCollectionMode();
	   return mode == TRCCollectionMode.EXECUTION_FULL_LITERAL
		|| mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL
		|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL
		|| mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
   }
   
   public static boolean hasExecutionInfo(final EObject object) {
	   TRCAgentProxy agentProxy = getAgentProxy(object);
	   if(agentProxy == null){
		   return false;
	   }
	   TRCCollectionMode mode = agentProxy.getCollectionMode();
	   return mode == TRCCollectionMode.EXECUTION_FULL_LITERAL
				|| mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL
				|| mode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL
				|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
   }
   
   public static boolean hasHeapInfo(final EObject object) {
	   TRCAgentProxy agentProxy = getAgentProxy(object);
	   if(agentProxy == null){
		   return false;
	   }	   
	   TRCCollectionMode mode = agentProxy.getCollectionMode();
	   return mode == TRCCollectionMode.HEAP_FULL_LITERAL
				|| mode == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL
				|| mode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL
				|| mode == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
   }
   
   private static boolean hasOptionSet(final TRCAgentProxy agentProxy, final String optionName, final Object value) {
	   EList configurations = agentProxy.getConfigurations();
	   if (configurations == null) {
		   return false;
	   }

	   Iterator i = configurations.iterator();
	   while (i.hasNext()) {
		   TRCConfiguration config = (TRCConfiguration)i.next();
		   EList options = config.getOptions();
		   Iterator j = options.iterator();
		   while (j.hasNext()) {
			   TRCOption option = (TRCOption)j.next();
			   if (optionName.equals(option.getKey())) {
				   return value.toString().equals(option.getValue().toString());
			   }
		   }
	   }
	   return false;
   }

private static TRCAgentProxy getAgentProxy(final EObject object) {
	   if (object instanceof TRCAgentProxy) {
		   return (TRCAgentProxy) object;
	   } else if (object instanceof TRCProcessProxy) {
		   return getAgentProxy((TRCProcessProxy) object);
	   } else if (object instanceof TRCNode) {
		   return getAgentProxy((TRCNode) object);
	   } else if (object instanceof TRCMonitor) {
		   return getAgentProxy((TRCMonitor) object);
	   }
	   return null;
   }

	private static TRCAgentProxy getAgentProxy(final TRCMonitor monitor) {
		Object[] nodes = (monitor).getNodes().toArray();
		for (int i = 0; i < nodes.length; i++) {
		    TRCAgentProxy agentProxy = getAgentProxy((TRCNode) nodes[i]);
			if (agentProxy != null) {
		    	return agentProxy;
		    }
		}
		return null;
	}

	private static TRCAgentProxy getAgentProxy(final TRCNode node) {
		Object[] processes = node.getProcessProxies().toArray();
		for (int i = 0; i < processes.length; i++) {
			TRCAgentProxy agentProxy = getAgentProxy((TRCProcessProxy) processes[i]);
			if (agentProxy != null) {
				return agentProxy;
			}
		}
		return null;
	}

	private static TRCAgentProxy getAgentProxy(final TRCProcessProxy processProxy) {
		Object[] agents = (processProxy).getAgentProxies().toArray();
		for (int i = 0; i < agents.length; i++) {
			TRCAgentProxy agentProxy = (TRCAgentProxy) agents[i];
			if (agentProxy.getAgent() != null) {
				return agentProxy;
			}
		}
		
		return null;
	}

}
