/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessMap.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;
import org.eclipse.debug.core.model.*;
import org.eclipse.hyades.models.hierarchy.*;

/**
 * A mapping between @link{TRCProcessProxy}s and @link{IProcess}es.
 * This is needed to retrieve the @link{IProcess} and @link{ILaunch}
 * when, for example, relaunching from a @link{TRCProcessProxy}.
 */
public class ProcessMap {
	private static final Map _map = new HashMap();

	/**
	 * Maps the given @link{TRCProcessProxy} to the given @link{IProcess}. This
	 * should be done during launch.
	 * 
	 * @param proxy The @link{TRCProcessProxy} associated with the
	 *    @link{IProcess}.
	 * @param process The @link{IProcess} associated with the
	 *    @link{TRCProcessProxy}.
	 */
	public static final void put(TRCProcessProxy proxy, IProcess process) {
		synchronized (_map) {
			_map.put(proxy, process);
		}
	}

	/**
	 * Gets the @link{IProcess} associated with the given
	 * @link{TRCProcessProxy}.
	 * 
	 * @param proxy The @link{TRCProcessProxy} from which to get the
	 *    @link{IProcess}.
	 * @return The @link{IProcess} associated with the given
	 *    @link{TRCProcessProxy}.
	 */
	public static final IProcess get(TRCProcessProxy proxy) {
		synchronized (_map) {
			return (IProcess) _map.get(proxy);
		}
	}
	
	/**
	 * Removes the entry associated with the given
	 * @link{TRCProcessProxy}.
	 * 
	 * @param proxy The @link{TRCProcessProxy} that was removed.
	 */
	public static final void remove(TRCProcessProxy proxy) {
		synchronized (_map) {
			_map.remove(proxy);
		}
	}
}
