/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessProxyAdapter.java,v 1.3 2006/04/24 19:23:41 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.swt.widgets.Display;
/**
 * This adapter listens for changes to objects in a DBResource and updates the
 * database accordingly.
 */
public class ProcessProxyAdapter extends AdapterImpl {

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		if (notification.getEventType()==Notification.SET
				&& notification.getFeature()==HierarchyPackage.eINSTANCE.getTRCProcessProxy_Name())
		{
			Display.getDefault().syncExec(
					new Runnable(){
						public void run(){
							INavigator nav = HyadesUtil.getActiveNavigator();
							if (nav!=null)
								nav.getViewer().refresh();
						}
					});
		}
	}
}
