/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingElementModifier.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.viewers.*;

public class ProfilingElementModifier implements ICellModifier
{
	protected CheckboxTableViewer fViewer;

	public ProfilingElementModifier(CheckboxTableViewer viewer)
	{
		fViewer = viewer;
	}
	public boolean canModify(Object element, String property) {
		return true;
	}
	public Object getValue(Object element, String property)
	{
		  
		if(property.equals(ProfilingTypeElement.P_NAME))
		  return ((ProfilingTypeElement)element).getName();
		return null;

	}
	public void modify(Object element, String property, Object value)
	{
		try {
		if(element instanceof TableItem)
		{		
			Object data = ((TableItem)element).getData();
			
			if(data != null && data instanceof ProfilingTypeElement)
			{
				ProfilingTypeElement e = (ProfilingTypeElement)data;

			 if (ProfilingTypeElement.P_NAME.equals(property))
				{
					if(value != null && !e.getName().equals(value.toString()))
					{
						e.setName(value.toString());
					}
						
				}
								
			}	
		}
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
	}

}
