/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Sorter.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Comparator;

import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;


public class Sorter implements Comparator {
	public int compare(Object e1, Object e2) {
		if (e1 != null && e2 != null) {
			if (e1 instanceof IProfilingSetTypeGroup && e2 instanceof IProfilingSetTypeGroup) {
				IProfilingSetTypeGroup g1 = (IProfilingSetTypeGroup)e1;
				IProfilingSetTypeGroup g2 = (IProfilingSetTypeGroup)e2;
				return g1.getName().compareTo(g2.getName());
			}
			else if (e1 instanceof IProfilingSetType && e2 instanceof IProfilingSetType) {
				IProfilingSetType t1 = (IProfilingSetType)e1;
				IProfilingSetType t2 = (IProfilingSetType)e2;
				return t1.getName().compareTo(t2.getName());
			}
		}
		return 0;
	}
}
