/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreeContentProvider.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider implements ITreeContentProvider {

	private TraceProfileOverviewUI _overviewUI;	
	
	public TreeContentProvider(TraceProfileOverviewUI overviewUI) {
		super();
		_overviewUI = overviewUI;
	}
	
	public Object[] getChildren(Object element) {
		if(element instanceof IProfilingSetTypeGroup) {
			return _overviewUI.getManagerCopy().getProfilingTypesForGroup(((IProfilingSetTypeGroup)element).getId());
		}	
		return new Object[0];
	}

	public Object[] getElements(Object element) {
		return _overviewUI.getManagerCopy().getProfilingTypesGroups().values().toArray();
	}

	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}

	public Object getParent(Object element) {
		if(element instanceof IProfilingSetType) {
			String group = ((IProfilingSetType)element).getGroup();
			if(group != null) {
				return _overviewUI.getManagerCopy().getProfilingTypesGroups().get(group);					
			}				
		}
		return "";
	}

	public void dispose() {
	}

	public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
	}
}


