/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddWizard.java,v 1.8 2005/08/09 02:48:49 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;

public class AddWizard extends ProfileSetWizard {

	public AddWizard(TraceProfileOverviewUI overviewUI)
	{
		super(overviewUI);
	}
	
	
	public void initializeSet()
	{
	    String name = getNewProfileSetName();
		String description = TraceMessages.FLTS_DEFD;
		
		init(org.eclipse.ui.PlatformUI.getWorkbench(), null);
		setWindowTitle(TraceMessages.APRFS_D);

		ProfilingSet set = new ProfilingSet(name + System.currentTimeMillis(), name, description);
		getProfilingSetsManagerCopy().getProfilingSets().put(set.getId(), set);
		
		Object [] profilingTypes = getProfilingSetsManagerCopy().getProfilingTypes().values().toArray();
		
		if (profilingTypes.length > 0)
			set.getProfilingTypes().add(((IProfilingSetType)profilingTypes[0]).getId());
		
		super.initializeSet(set);
	}
	
	private String getNewProfileSetName()
	{
		String defaultName = TraceMessages.FLTS_DEFN;
		
		int i = 1;
		String name = defaultName;
		while (profileNameExists(name))
		{
			name = defaultName + " (" + i + ")";
			i++;
		}
		
		return name;
	}	
	
	protected String getSetId()
	{
		return null;
	}
}
