/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditWizard.java,v 1.6 2005/08/09 02:48:49 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

public class EditWizard extends ProfileSetWizard {

	private String id;
	
	public EditWizard(TraceProfileOverviewUI overviewUI)
	{
		super(overviewUI);
	}	
	
	public void initializeSet(ProfilingSet set)
	{
		id = set.getId();

		init(org.eclipse.ui.PlatformUI.getWorkbench(), null);
		setWindowTitle(TraceMessages.EFS_T);
		
		super.initializeSet(set);
	}
	
	protected String getSetId()
	{
		return id;
	}
}
