/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportTraceAdvancedTabAttributeSet.java,v 1.17 2006/12/29 19:16:45 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.BasicTraceFeatureFilterAttribute;
import org.eclipse.hyades.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;


public class ImportTraceAdvancedTabAttributeSet implements IAdvancedTabAttributeSet
{
	private static RelationalOperators[] _operators = new RelationalOperators[]
    {
		RelationalOperators.get(RelationalOperators.EQ),
		RelationalOperators.get(RelationalOperators.NEQ),		
		RelationalOperators.get(RelationalOperators.LIKE)
    };
	
	
	private IFilterAttribute[] _attributes = new IFilterAttribute[]
	{
		new BasicTraceFeatureFilterAttribute("ftimptrace_ad1"
				, IContextAttributes.PACKAGE_NAME, TracePackage.eINSTANCE.getTRCPackage_Name(), _operators, true),
		new BasicTraceFeatureFilterAttribute("ftimptrace_ad2"
				, IContextAttributes.CLASS_NAME, TracePackage.eINSTANCE.getTRCClass_Name(), _operators, true),
		new BasicTraceFeatureFilterAttribute("ftimptrace_ad3"
				, IContextAttributes.METHOD_NAME, TracePackage.eINSTANCE.getTRCMethod_Name(), _operators, true),
		new BasicTraceFeatureFilterAttribute("ftimptrace_ad4"
				, IContextAttributes.THREAD_NAME, TracePackage.eINSTANCE.getTRCThread_Name(), _operators, true)
	};
	
	
	public IFilterAttribute[] getAttributes() {
		String context = UIPlugin.getDefault().getPreferenceStore().getString(CommonUITraceConstants.TRACE_IMPORT_FILTER_CONTEXT);
		
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i] instanceof BasicTraceFeatureFilterAttribute)
				((BasicTraceFeatureFilterAttribute)_attributes[i]).setContext(context);
		}
		
		return _attributes;
	}
}

	
