/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportTraceFilterUI.java,v 1.1 2005/07/20 21:48:19 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.ImportFilterUI;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ImportTraceFilterUI {

	private String _filterScope;
    protected ImportFilterUI _filter;

	public ImportTraceFilterUI(String filterScope) {
		_filterScope = filterScope;
	}
	
	public Composite createControl(Composite parent) {
	    	GridLayout layout;
	    	GridData data;
	    	
	    	Composite composite = new Composite (parent, SWT.NULL);
	    	
	    	layout = new GridLayout();
	    	layout.numColumns = 1;
	    	composite.setLayout(layout);
	    	
	    	data = GridUtil.createFill();
	    	composite.setLayoutData(data);//new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
	    	
	    	composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	    	
	    	_filter = new ImportFilterUI(_filterScope);
	        Composite fc = _filter.createControl(composite);
	        PlatformUI.getWorkbench().getHelpSystem().setHelp(fc, UIPlugin.getPluginId() + ".xmlifilter");
	        
	        return composite;
	    }    
	   
	   public SimpleSearchQuery getSelectedFilter() {
		  return _filter.getSelectedFilter();
	   }
	   
	   public void setSelectedFilter(String selectedFilterName, String selectedFilterType) {
		   _filter.setSelectedFilter(selectedFilterName, selectedFilterType);
	   }
}
