/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation, Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportTraceRangeUI.java,v 1.7 2009/07/31 19:29:26 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.text.ParseException;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;

/**
 *  Page 2 of the base resource import-from-zip Wizard.
 *  which specific the range of file to be imported.
 */

public class ImportTraceRangeUI implements SelectionListener,ModifyListener {

	Label _regionLabel;
	Button _wholeFileBtn;
	Button _inRangeBtn;
	Label _startLabel;
	Text _startText;
	Label _ofFileLabel1;		
	Label _ofFileLabel2;
	Label _stopLabel;
	Text _stopText;
	double startValue	= 0.0;
	double stopValue	= 100.0;
	WizardPage _wizardPage;
	
    private Button _showExecFlow;
    private Button _showExecStatistic;
    private Button _showHeapStatistic;
    private Button _showThreadStatistic;
    private Label _description;

public ImportTraceRangeUI(WizardPage wp) {
	_wizardPage = wp;	
}

public Composite createControl(Composite parent) {
	
	Composite composite = new Composite(parent, SWT.NULL);
	composite.setLayout(new GridLayout());
	
	GridData gd = GridUtil.createFill();
	composite.setLayoutData(gd);

	Label label = new Label(composite,SWT.NULL);
	label.setText(TraceMessages.IMP_OPT);

	addRangeOption(composite);
	addStatisticOption(composite);
	
	createSpacer(composite);
	
	initData();
	
	return composite;
}

private void addRangeOption(Composite parent) {

	GridLayout layout;
	
	Composite optionGroup = new Composite(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 7;
	layout.verticalSpacing=5;
	optionGroup.setLayout(layout);
	
	GridData gd;
	_wholeFileBtn = new Button(optionGroup, SWT.RADIO);
	gd = new GridData();
	gd.horizontalSpan = 7;
	_wholeFileBtn.setLayoutData(gd);
	_wholeFileBtn.setText(TraceMessages.IMP_COMP);
	
	_inRangeBtn = new Button(optionGroup, SWT.RADIO);
	_inRangeBtn.setText(TraceMessages.IMP_PART);
	
	_startLabel = new Label(optionGroup, SWT.NONE);
	_startLabel.setText(TraceMessages.FROM_STR);

	//get locale information for showing the range input in different layout
	//see https://bugs.eclipse.org/bugs/show_bug.cgi?id=285283
	ULocale ulocale = ULocale.getDefault();
	boolean turkish = ulocale.getLanguage().equals("tr");

	//show % in front of input for turkish locale
	if (turkish) {
		_ofFileLabel1 = new Label(optionGroup, SWT.NONE);
		_ofFileLabel1.setText(TraceMessages.FPERC);
		
		_startText = new Text(optionGroup, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_startText.setLayoutData(gd);
		
		_stopLabel = new Label(optionGroup, SWT.NONE);
		_stopLabel.setText(TraceMessages.TO_STR);

		_ofFileLabel2 = new Label(optionGroup, SWT.NONE);
		_ofFileLabel2.setText(TraceMessages.FPERC);			

		_stopText = new Text(optionGroup, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_stopText.setLayoutData(gd);	
		
	}
	else {
		_startText = new Text(optionGroup, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_startText.setLayoutData(gd);
		
		_ofFileLabel1 = new Label(optionGroup, SWT.NONE);
		_ofFileLabel1.setText(TraceMessages.FPERC);
		
		_stopLabel = new Label(optionGroup, SWT.NONE);
		_stopLabel.setText(TraceMessages.TO_STR);

		_stopText = new Text(optionGroup, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 30;
		_stopText.setLayoutData(gd);	
		
		_ofFileLabel2 = new Label(optionGroup, SWT.NONE);
		_ofFileLabel2.setText(TraceMessages.FPERC);			
	}

	_wholeFileBtn.addSelectionListener(this);
	_inRangeBtn.addSelectionListener(this);
	_startText.addModifyListener(this);
	_stopText.addModifyListener(this);
}

private void addStatisticOption(Composite parent) {
   GridLayout layout;
   GridData data;

   Group _showExecGroup = new Group(parent, SWT.NULL);

   data = GridUtil.createHorizontalFill();
   data.horizontalSpan = 2;
   _showExecGroup.setLayoutData(data);
   layout = new GridLayout();
   layout.numColumns = 1;
   _showExecGroup.setLayout(layout);

   _showHeapStatistic = new Button(_showExecGroup, SWT.RADIO);
   _showHeapStatistic.setText(TraceMessages.HEAP_STAT);
   _showThreadStatistic = new Button(_showExecGroup, SWT.RADIO);
   _showThreadStatistic.setText(TraceMessages.THREAD_STAT);
   _showExecStatistic = new Button(_showExecGroup, SWT.RADIO);
   _showExecStatistic.setText(TraceMessages.EXEC_STAT);
   _showExecFlow = new Button(_showExecGroup, SWT.RADIO);
   _showExecFlow.setText(TraceMessages.FULL_DATA);

   _description = new Label(parent, SWT.WRAP);
   _description.setText(TraceMessages.ANHEAP);
   
   data = GridUtil.createFill(); 
   data.horizontalIndent = 20;
   data.widthHint = 50;
   data.heightHint = 80;
   _description.setLayoutData(data);

   _showHeapStatistic.setSelection(true);

   _showHeapStatistic.addSelectionListener(this);
   _showThreadStatistic.addSelectionListener(this);
   _showExecStatistic.addSelectionListener(this);
   _showExecFlow.addSelectionListener(this);
}

protected void createSpacer(Composite parent) {
    Label spacer = new Label(parent, SWT.NONE);
    GridData data = new GridData();
    data.horizontalAlignment = GridData.FILL;
    data.verticalAlignment = GridData.BEGINNING;
    spacer.setLayoutData(data);
}

private void initData()
{
	NumberFormat numFormat = NumberFormat.getInstance();
	_wholeFileBtn.setSelection(true);
	_startText.setText( numFormat.format( startValue ) );
	_stopText.setText( numFormat.format( stopValue ) );
	setRangeInputEnable(false);	
}

public Button getWholeFileBtn()
{
	return _wholeFileBtn;
}
public Button getInRangeBtn()
{
	return _inRangeBtn;
}
public boolean getWholeFileSelection()
{
	return _wholeFileBtn.getSelection();
}
public boolean getInRangeSelection()
{
	return _inRangeBtn.getSelection();
}
public double getStartRange()
{
	return startValue;
}
public double getStopRange()
{
	return stopValue;
}
public String checkRegionValue()
{
	if (_startText.getText().trim().equals("") || _stopText.getText().trim().equals(""))
			return TraceMessages.CANT_EMPTV;
		else
		{
			try 
			{
				NumberFormat numFormat = NumberFormat.getInstance();
				startValue = numFormat.parse( _startText.getText().trim() ).doubleValue();
				stopValue = numFormat.parse( _stopText.getText().trim() ).doubleValue();
				
				if (startValue > stopValue)
					return TraceMessages.STRT_LS;
				else if (startValue == stopValue)
					return TraceMessages.CNT_SAME;
				else if (startValue <0 || startValue >100 || stopValue<0 || stopValue >100)
					return TraceMessages.INV_IMPR;
				else 
				{
					return null;
				}
			}
			catch (NumberFormatException nfe)
			{
				return TraceMessages.INV_IMPS;
			} 
			catch (ParseException pe) {
				return TraceMessages.INV_IMPS;
			}
		}
}

public void modifyText(ModifyEvent e)
{
	if (e.widget == _startText || e.widget == _stopText)
			_wizardPage.setErrorMessage(checkRegionValue());
}


public void setRangeInputEnable(boolean enable)
{

	_startLabel.setEnabled(enable);
	_startText.setEnabled(enable);
	_ofFileLabel1.setEnabled(enable);
	_stopLabel.setEnabled(enable);
	_stopText.setEnabled(enable);
	_ofFileLabel2.setEnabled(enable);
}

public void widgetSelected(SelectionEvent e)
{
	if (e.widget == _wholeFileBtn)
	{
		setRangeInputEnable(false);
		startValue =0;
		stopValue = 100;
		_wizardPage.setErrorMessage(null);
	}
	else if (e.widget == _inRangeBtn)
	{
		setRangeInputEnable(true);
		_wizardPage.setErrorMessage(checkRegionValue());	
	}
	else if (e.widget == _showExecStatistic) 
	{
      	_description.setText(TraceMessages.AN_EXTM);
	} else if (e.widget == _showHeapStatistic) 
	{
      	_description.setText(TraceMessages.ANHEAP);
	} else if (e.widget == _showThreadStatistic) 
	{
      	_description.setText(TraceMessages.ANTHREAD);
	} else if (e.widget == _showExecFlow) 
	{
      	_description.setText(TraceMessages.AN_EXTMF);
	}
}

public void widgetDefaultSelected(SelectionEvent e) {}

public Button getshowExecFlow() {
	return _showExecFlow;
}

public Button getshowExecStatistic() {
	return _showExecStatistic;
}

public Button getshowHeapStatistic() {
	return _showHeapStatistic;
}

public Button getshowThreadStatistic() {
	return _showThreadStatistic;
}

public Label getdescription() {
	return _description;
}

public Text getstartText() {
	return _startText;
}

public Text getstopText() {
	return _stopText;
}

}
