/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewMonitorWizard.java,v 1.10 2006/09/20 18:53:52 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;


public class NewMonitorWizard extends NavigatorWizard  /* Ali M.: Extended Navigator wizard */
{

	protected PDProjectExplorer fViewer;

	protected IStructuredSelection fSelection;

	protected IResource fResource;

	protected NewMonitorWizardPage fPage;

	public NewMonitorWizard() {
		setNeedsProgressMonitor(true);
	}

	public void addPages() {
		setWindowTitle(TraceMessages.MONITOR_WT);
		fPage = new NewMonitorWizardPage(
				"org.eclipse.pd.core.wizard.NewMonitorPage", fResource);
		addPage(fPage);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		fSelection = selection;
		if (selection instanceof IStructuredSelection) {
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext()) {
				Object cg = enum1.next();
				if (cg instanceof IResource) {
					fResource = (IResource) cg;
				}
			}
		}

		setDefaultPageImageDescriptor(UIPlugin
				.getImageDescriptor(PDPluginImages.IMG_UI_WZ_NEWMON));
	}

	public boolean performFinish() {
		if (fPage.finish()) {
			fViewer.getViewer().refresh();
			fViewer.selectObject(fPage.getMonitor());

			return true;
		}
		return false;
	}

	public void setViewer(PDProjectExplorer viewer) {
		fViewer = viewer;

		((PDProjectViewer) viewer.getViewer()).createSelectedNodeChildren();
	}
}
