/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewMonitorWizardPage.java,v 1.12 2006/12/29 19:16:45 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID nmwp0000 for in new monitor wizard page
*/

public class NewMonitorWizardPage  extends WizardPage
				   implements ModifyListener
{
	protected IResource fSelection;
	protected TraceLocationUI _locationUI;
	private TRCMonitor fMonitor;

  public NewMonitorWizardPage(String name, IResource selection)
  {
	super(name);
	setTitle(TraceMessages.CR_MT);
	setDescription(TraceMessages.CR_MTD);

	fSelection = selection;
  }  
  public void createControl(Composite parent)
  {
	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();	
	content.setLayoutData(gd);

	_locationUI = new TraceLocationUI();
	_locationUI.createControl(content);
	_locationUI.setEnabledBrowse(false);
	_locationUI.setEnabledLocation(false);

//  top level group
	Composite group = new Composite(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 2;
	layout.verticalSpacing=0;           
	group.setLayout(layout);
	group.setLayoutData(GridUtil.createFill());
	
	//add listeners
	_locationUI.getLocation().addModifyListener(this);
	_locationUI.getMonitor().addModifyListener(this);        
	
	_locationUI.getMonitor().setFocus();

	setControl(content);

	_locationUI.setMonitor("");
	if(fSelection != null)
	   _locationUI.setLocation(fSelection.getFullPath().toOSString());  

	setPageComplete(false);

	PlatformUI.getWorkbench().getHelpSystem().setHelp(
	parent,
	UIPlugin.getPluginId()+".nmwp0000");
	
  }  
  public boolean finish()
  {
	String name = _locationUI.getMonitor().getText().trim();
	String location = _locationUI.getLocation().getText().trim();

	IContainer container = PDCoreUtil.createContainer(new Path(location));							
	PDCoreUtil.createMonitor(container, name);
	
	return(true);
	
  }  
public TRCMonitor getMonitor() {
	return fMonitor;
}

public void modifyText(ModifyEvent event)
{
	String containerName = _locationUI.getLocation().getText().trim();
	String fileName = _locationUI.getMonitor().getText().trim();
	
	if(containerName.equals("") || containerName.equals(""))
	{
		setErrorMessage(null);          		
		setPageComplete(false);
		return;
	}

	if(event.widget == _locationUI.getMonitor())
	{
		setErrorMessage(null);          

		IWorkspace workbench = UIPlugin.getPluginWorkbench();

		Path path = new Path(containerName);
		IContainer container = null;
		
		IResource res = workbench.getRoot().findMember(path);
		if(res == null || !res.exists())   
		{
			setPageComplete(true);
			return;                             
		}

		if(!(res instanceof IContainer))
	    {
			setErrorMessage(NLS.bind(TraceMessages.CT_INV, containerName));               
		    
			setPageComplete(false);
			return;                             
		    
	    }
		
		container = (IContainer) res; 
		res = container.findMember(fileName+File.separator+CommonUIConstants.MONITOR_EXT);
		if(res != null)
		{
			setErrorMessage(NLS.bind(TraceMessages.F_ALD_EX,
					new Object[] {containerName, File.separator, fileName, CommonUIConstants.MONITOR_EXT}));                                   
			setPageComplete(false);
			return;                     			
		}
			
		ArrayList monitors = PDContentProvider.getMonitors(container);
		for(int idx=0; idx<monitors.size(); idx++)
		{
			TRCMonitor monitor = (TRCMonitor)monitors.get(idx);
			if(monitor != null && monitor.getName().equals(fileName))
			{
				setErrorMessage(NLS.bind(TraceMessages.F_ALD_EX,
						new Object[] {containerName, File.separator, fileName, CommonUIConstants.MONITOR_EXT}));                                   
				setPageComplete(false);
				return;                     
			}
		}

		setPageComplete(true);
	}
}
}
