/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenMonitorWizard.java,v 1.7 2005/08/09 02:48:49 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenMonitorWizard extends NewMonitorWizard {
	TRCMonitor fMonitor;

	public OpenMonitorWizard() {
		super();
	}

	public void addPages() {
		setWindowTitle(TraceMessages.PROP);
		fPage = new OpenMonitorWizardPage("openMonitorPage", fResource);
		addPage(fPage);
	}

	public TRCMonitor getMonitor() {
		return fMonitor;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		if (selection instanceof IStructuredSelection) {
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext()) {
				Object obj = enum1.next();
				if (obj instanceof TRCMonitor) {
					fMonitor = (TRCMonitor) obj;
				}
			}
		}

		setDefaultPageImageDescriptor(UIPlugin
				.getImageDescriptor(PDPluginImages.IMG_UI_WZ_MON_PROP));
	}

	public boolean performFinish() {
		return fPage.finish();
	}

	public void setViewer(PDProjectExplorer viewer) {
		fViewer = viewer;

		fResource = HyadesUtil.getSelectionFolder(fViewer);
	}
}
