/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenMonitorWizardPage.java,v 1.6 2005/08/09 02:48:49 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.swt.widgets.*;
import org.eclipse.ui.PlatformUI;
import org.eclipse.core.resources.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;

/*
* CONTEXT_ID omwp0000 for open monitor wizard page
*/

public class OpenMonitorWizardPage extends NewMonitorWizardPage {
	public OpenMonitorWizardPage(String name, IResource selection) {
		super(name, selection);
		setTitle(TraceMessages.MONP_T);
		setDescription(TraceMessages.MONP_TD);
	}
	public void createControl(Composite parent) {
		super.createControl(parent);

		_locationUI.setEnabled(false);

		populateData();
		setErrorMessage(null);
		setPageComplete(true);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			parent,
			UIPlugin.getPluginId() + ".omwp0000");
	}
	public boolean finish() {
		return true;

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/05/2000 3:17:53 PM)
	 */
	protected void populateData() {
		TRCMonitor monitor = ((OpenMonitorWizard) getWizard()).getMonitor();

		if (monitor == null)
			return;

		_locationUI.getMonitor().setText(monitor.getName());

	}
}
