/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentPage.java,v 1.14 2006/08/23 16:25:24 amehregani Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID opap0000 for open profile agent page
*/

public class OpenProfAgentPage  extends WizardPage 
{
	protected INavigator fViewer;
	protected TraceProfileFiltersUI _profileUI;
		
  public OpenProfAgentPage(String name, INavigator viewer)     

  {
	super(name);
	//setTitle("Trace Profile Data"); 
	setTitle(TraceMessages.PROFA_T);
	setDescription(TraceMessages.PROFA_TD); 
	fViewer = viewer;
	  
  }    /**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:48:53 PM)
 * @param show boolean
 */      
  public void createControl(Composite parent)
  {
	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	gd.widthHint = 500;
	gd.heightHint = 400;
	content.setLayoutData(gd);

	_profileUI = new TraceProfileFiltersUI();
	_profileUI.createControl(content);

	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null || !agent.isActive())
	{
		_profileUI.setAgentTerminated(true);
		_profileUI.enable(false);
	}
	
	setControl(content);

	populateData();

	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		parent,
	UIPlugin.getPluginId()+".opap0000");
  }  
  public boolean finish()
  {     
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null || !agent.isActive())
	  return true;

	try {
		Object[] configs = agent.getConfigurations().toArray();

		if(configs.length > 0)
		{
			setConfiguration((TRCConfiguration)configs[0]);                 
		}
		else
		{
			HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();         
			TRCConfiguration config = factory.createTRCConfiguration();
			config.setActive(true);
			config.setName(TraceMessages.DEF_SETNM);
			config.setAgentProxy(agent);
			agent.getConfigurations().add(config);

			setConfiguration(config);           
		}
		
		/* Send the configuration to the agent if the trace is active and monitored.
		 * The configuration is only send if 'shouldSend' is set. */
		if(agent.isActive() && agent.isMonitored())
		{
			TRCProcessProxy process = agent.getProcessProxy();
			TRCNode node = process.getNode();
			sendConfigurationToAgent(agent, node.getName(), process.getPid());			
			
		}
		
	}
	catch(ConcurrentModificationException exc)
	{
		exc.printStackTrace();
	}
		
	return true;    

  } 
  

  private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId)
  {
  	Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
  	if(node == null)
  		return;

  	
  	Process p = node.getProcess(String.valueOf(processId));

  	if(p != null)
  	{
  		try {
  			Agent a = p.getAgent(agent.getName());
  			PDCoreUtil.setAgentConfiguration(agent, a);
  			if(a != null && a.isActive()) {
  			  a.publishConfiguration();

  			  /* Apply the filters */
  			  CustomCommand command = new CustomCommand();
  			  command.setData("APPLYFILTERS");
  			  a.invokeCustomCommand(command);	
  			  
  			}			
  		}
  		catch(InactiveAgentException aex)
  		{
  		}
  	}
  }
  
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null)
	  return;

	EList filters = null;
	
	EList configs = agent.getConfigurations();
	Iterator i = configs.iterator();
	
	/* Ali M. - Iterate through each configuration until the filter configuration is
	 * found */	
	while (i.hasNext())
	{
		TRCConfiguration config = (TRCConfiguration)i.next();
		filters = config.getFilters();
		
		if (filters.size() > 0)
		{
			updateConfigData(config.getName(), filters);                         
			return;			
		}
	}

	updateConfigData(TraceMessages.DEF_SETNM, filters);                     
}

protected void setConfiguration(TRCConfiguration config)
{
	try {
	
	Object[] filters = config.getFilters().toArray();

	//delete the filters
	for(int idx=0; idx<filters.length; idx++)   
	{
		((TRCFilter)filters[idx]).setConfiguration(null);
	}

	//add the UI options    
	HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory(); 
	//add UI filters
	String selected = _profileUI.getActiveFilterSet();
	ArrayList filterSet = _profileUI.getFilterSet();
	for(int i=0; i<filterSet.size(); i++)
	{
		FilterSetElement set = (FilterSetElement) filterSet.get(i);
		if(set.getId().equals(selected))
		{
			config.setActive(true);
			config.setName(set.getDisplayName());
			UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, set.getName());
						
			ArrayList filterList = set.getChildren();
			for(int idx=0; idx<filterList.size(); idx++)
			{
				FilterTableElement elem = (FilterTableElement)filterList.get(idx);
				
				TRCFilter filter = factory.createTRCFilter();
				filter.setMode(elem.getVisibility().equals(TraceMessages.INCLUDE)?"INCLUDE":"EXCLUDE");
				filter.setPattern(elem.getText());
		        filter.setOperation(elem.getMethod());		
				filter.setType("CLASS");			
				filter.setActive(new Boolean(true));
		
				filter.setConfiguration(config);       
			}
			
			break;
		}
	}
		
}
catch(ConcurrentModificationException exc)
{
	exc.printStackTrace();
}
		
}
protected void updateConfigData(String name, EList filters)
{	
	ArrayList list = new ArrayList();
	if (filters != null)
	{
		Iterator i = filters.iterator();
		while (i.hasNext())
		{
			TRCFilter filter = (TRCFilter)i.next(); 
			String method = filter.getOperation();
			if(method!=null)  			 
				list.add(new FilterTableElement(filter.getPattern(), method, filter.getMode().equals("INCLUDE")
						?TraceMessages.INCLUDE
						:TraceMessages.EXCLUDE));
			else	
				list.add(new FilterTableElement(filter.getPattern(), "*", filter.getMode().equals("INCLUDE")
						?TraceMessages.INCLUDE
						:TraceMessages.EXCLUDE));			
		}
	}
	
	FilterSetElement elem = new FilterSetElement(UIPlugin.PLUGIN_ID + "." + name + System.currentTimeMillis());
	elem.setKey(null);
	elem.setName(name);
	elem.setChildren(list);
	_profileUI.addFilterSet(elem);
	_profileUI.setActiveFilterSet(elem);
}

	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			if (!((OpenProfAgentWizard)getWizard()).isProfilingAgent()) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(TraceMessages.FLT_IGN);
			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(TraceMessages.PROFA_TD);
			}
		}
	}


}
