/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentWizard.java,v 1.12 2006/09/20 18:53:52 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.ui.IWorkbench;

public class OpenProfAgentWizard extends NavigatorWizard /* Ali M.: Extended Navigator wizard */
{
	protected TRCAgentProxy fAgent;

	protected OpenProfAgentPage fFilterPage;

	protected OpenProfAgentFolderPage fFolderPage;

	protected OpenProfAgentOptionsPage fPropertyPage;

	private boolean debug = UIPlugin.getDefault().getPreferenceStore()
			.getBoolean(TraceConstants.DEBUG_OPTION);

	public OpenProfAgentWizard()
	{
		super();
	}

	public void addPages()
	{
		setWindowTitle(TraceMessages.PROP);
		fFolderPage = new OpenProfAgentFolderPage("folderPage", getViewer());
		fFilterPage = new OpenProfAgentPage("agentPage", getViewer());
		if (debug)
			fPropertyPage = new OpenProfAgentOptionsPage("propertiesPage");

		addPage(fFolderPage);
		addPage(fFilterPage);
		if (debug)
			addPage(fPropertyPage);
	}

	public TRCAgentProxy getAgent()
	{
		return fAgent;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		if (selection instanceof IStructuredSelection)
		{
			Iterator enum1 = ((IStructuredSelection) selection).iterator();
			if (enum1.hasNext())
			{
				Object obj = enum1.next();
				if (obj instanceof TRCAgentProxy)
					fAgent = (TRCAgentProxy) obj;
			}
		}

		setDefaultPageImageDescriptor(UIPlugin
				.getImageDescriptor(PDPluginImages.IMG_UI_WZ_AGENT_PROP));
	}

	public boolean performFinish()
	{

		if (!fFolderPage.getFile().equals("")
				&& !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),
					getShell()))
				return false;
		}

		fFilterPage.finish();
		fFolderPage.finish();
		if (debug)
			fPropertyPage.finish();

		return true;
	}

	public boolean isProfilingAgent()
	{
		if (fAgent != null)
		{
			return (fAgent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) && !fAgent
					.getName().equals(CommonUIConstants.J2EE_AGENT_NAME));
		}
		return true;
	}

}
