/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileSetWizardPage1.java,v 1.9 2006/09/20 18:53:52 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProfileSetWizardPage1  extends WizardPage implements IProfileSetWizardPage, ModifyListener {

	private String _name;

	private Text _nameText;

	private String _description;

	private Text _descText;

	public ProfileSetWizardPage1(String pageId, String name, String description,
			ProfilingSetsManagerCopy managerCopy) {
		super(pageId);

		_name = name;
		_description = description;
		setImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_EDITPROFSET));		
	}

	/*
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {

		Composite result = (Composite) new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;
		Label label1;
		Label label2;

		layout = new GridLayout();
		layout.numColumns = 2;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.widthHint = 400;
		result.setLayoutData(data);

		label1 = new Label(result, SWT.NONE);
		label1.setText(TraceMessages.PFS_N);
		_nameText = new Text(result, SWT.BORDER);
		_nameText.setLayoutData(GridUtil.createHorizontalFill());

		label2 = new Label(result, SWT.NONE);
		label2.setText(TraceMessages.PRFS_DE);
		label2.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
		data = GridUtil.createHorizontalFill();
		data.heightHint = 80;
		data.widthHint = 400;		
		_descText = new Text(result, SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		_descText.setLayoutData(data);

		_nameText.addModifyListener(this);
		_descText.addModifyListener(this);

		if (_name == null)
			_name = TraceMessages.FLTS_DEFN;
		_nameText.setText(_name);

		if (_description == null)
			_description = TraceMessages.FLTS_DEFD;
		_descText.setText(_description);

		setControl(result);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(getControl(), UIPlugin.getPluginId() + ".prct0000");
		//setpag
	}

	public boolean performApply(ProfilingSetsManagerCopy copy) {
		_name = _nameText.getText().trim();
		_description = _descText.getText();

		((ProfileSetWizard) getWizard()).setProfileSetName(_name);
		((ProfileSetWizard) getWizard()).setProfileSetDescription(_description);
		((ProfileSetWizard) getWizard()).setNameToPages();

		return true;
	}

	public void modifyText(ModifyEvent e) {
		if (isCurrentPage())
			updatePage();
	}

	/*
	 * @see org.eclipse.hyades.trace.ui.internal.wizard.IAddWizardPage#initializeFrom(org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy)
	 */
	
	private void updatePage()
	{
		if (nameExists())
			setErrorMessage(TraceMessages.APRFS_NE);
		else if (nameOrDescriptionBlank())
			setErrorMessage(TraceMessages.APRFS_NB);
		else
			setErrorMessage(null);
		
		getWizard().getContainer().updateButtons();		
	}
	
	public void initializeFrom(ProfilingSetsManagerCopy copy) {
	}

	private boolean nameExists() {
		return ((ProfileSetWizard) getWizard()).profileNameExists(_nameText.getText().trim());
	}
	
	private boolean nameOrDescriptionBlank()
	{
		return _nameText.getText().trim().length() == 0 || _descText.getText().trim().length() == 0;
	}

	private boolean textFieldsOK() {
		return !nameExists() && !nameOrDescriptionBlank();
	}

	public boolean canFlipToNextPage() {
		return textFieldsOK();
	}

	public boolean isPageComplete() {
		return textFieldsOK();
	}
	
}
