/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILauncherHandler.java,v 1.3 2005/06/01 16:34:09 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.launcher;

import org.eclipse.hyades.models.hierarchy.*;


/**
 * 
 * Launcher Handler Type Interface
 * Related to the launcherHandler schema.
 * Classes implementing this interface are given control to the agent
 * and the process proxy during various points throughout the launch/attach
 * scenario.
 * They can set and get properties midway through a profile.
 **/
public interface ILauncherHandler{

	/**
	 * invoked after the TRCProcessProxy is created
	 * @param processProxy
	 */
	public void handleProcessLaunched(TRCProcessProxy processProxy);
	
	/**
	 * invoked after the TRCProcessProxy is set inactive
	 * @param processProxy
	 */
	public void handleProcessExited(TRCProcessProxy processProxy);
	
	/**
	 * invoked before the TRCAgentProxy resumes
	 * @param agentProxy
	 */
	public void handlePreAgentActive(TRCAgentProxy agentProxy);
	
	/**
	 * invoked after the TRCAgentProxy has resumed
	 * @param agentProxy
	 */
	public void handlePostAgentActive(TRCAgentProxy agentProxy);
	
	/**
	 * invoked after the TRCAgentProxy becomes inactive
	 * @param agentProxy
	 */
	public void handleAgentInactive(TRCAgentProxy agentProxy);
	
	
	}

