/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProfilingSetType.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.launcher;

import org.eclipse.jface.resource.ImageDescriptor;

/**
 * 
 * Profiling Set Type Interface
 */
public interface IProfilingSetType {
	
	/**
	 * @return Returns the type id.
	 */
	public String getId();
	
	/**
	 * @param id The id to set.
	 */
	public void setId(String id);
	
	/**
	 * @return Returns the image.
	 */
	public ImageDescriptor getImage();
	
	/**
	 * @param image The image to set.
	 */
	public void setImage(ImageDescriptor image);
	
	/**
	 * @return Returns the name.
	 */
	public String getName();
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name);
	
	/**
	 * @return Returns the profilingType.
	 */
	public IProfilingType getProfilingType();
	
	/**
	 * @param profilingType The profilingType to set.
	 */
	public void setProfilingType(IProfilingType profilingType);
	
	/**
	 * @return Returns the useFilters.
	 */
	public boolean isUseFilters();
	
	/**
	 * @param useFilters The useFilters to set.
	 */
	public void setUseFilters(boolean useFilters);
	
	/**
	 * @return Returns the description.
	 */
	public String getDescription();
	
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description);
	
	/**
	 * @return Returns the group.
	 */
	public String getGroup();
	
	/**
	 * @param group The group to set.
	 */
	public void setGroup(String group);
	
}
