/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingAttribute.java,v 1.4 2006/05/11 15:05:05 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.launcher;

/**
 * Agent Controller option passed to the launcher configuration 
 */
public class ProfilingAttribute {
	
	protected String name;
	protected String value;
	
	/* Contributor Id is an indicator of who owns this attribute.  This is not a required field */
	protected String contributorId;
	
	/* An indicator of whether this attribute should be used as part of the launch.  This
	 * attribute will be used if this is set to true */
	protected boolean enabled;
	
	
	/**
	 * attributes associated with each profiling set
	 * related with the attribute element of the profilingset 
	 * extension point
	 */
	public ProfilingAttribute(String name, String value) {
		super();
		
		this.name = name;
		this.value = value;
		enabled = true;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the value.
	 */
	public String getValue() {
		return value;
	}
	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	
	public String getContributorId()
	{
		return contributorId;
	}
	
	
	public void setContributorId(String contributorId)
	{
		this.contributorId = contributorId;
	}
	
	public boolean isEnabled()
	{
		return enabled;
	}
	
	public void setEnabled(boolean enabled)
	{
		this.enabled = enabled;
	}
}
