/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.ui.internal.control.provider;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlProvider;

public class ControlProviderLoader
{
	/* Set if type is toolbar */
	private IControlProvider controlProvider;

	/* The type of the controllable entity */
	private String type;
	
	
	private ControlProviderLoader(String type, IControlProvider controlProvider)
	{
		this.type = type;
		this.controlProvider = controlProvider;
	}
	
	
	public static ControlProviderLoader constructInstance(IConfigurationElement element)
	{
		String type = element.getAttribute("type");
		if (type == null)
			return null;
		
		IControlProvider controlProvider = null;
		try
		{
			controlProvider = (IControlProvider)element.createExecutableExtension("class");
			controlProvider.initialize(type);
		} 
		catch (CoreException e)
		{
			e.printStackTrace();
			return null;
		}
		
		return new ControlProviderLoader (type, controlProvider);		
	}

	public String getType()
	{
		return type;
	}
	
	
	public IControlProvider getControlProvider()
	{
		return controlProvider;
	}

}
