/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * 
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ControlUtility.java,v 1.3 2006/08/23 16:25:25 amehregani Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.control.provider;

import java.util.Hashtable;

import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;


/**
 * Provides common static methods shared by multiple classes
 * 
 * @author Ali Mehregani
 */
public class ControlUtility 
{	
	/** Keeps track of all the programmatically added toolbar items 
	 * KEY = Action id
	 * VALUE = The contributed toolbar item*/
	private static Hashtable previoslyContributedItems = new Hashtable();
	
	/**
	 * Adds the contirbutedControlItems to the contributionManager.
	 * 
	 * @param contributionManager The contribution manager
	 * @param contributedControlItems The contributed items to be added
	 */
	public static void addContributedItems(IContributionManager contributionManager, IControlItem[] contributedControlItems)
	{
		contributionManager.update(true);
		if (contributedControlItems == null)
			return;

		/* Find the group name */				
		Hashtable groups = new Hashtable();
		Hashtable existingItems = new Hashtable();
		IContributionItem[] items = contributionManager.getItems();
		for (int i = 0; i < items.length; i++)
		{
			/* If this happens to be an item that was added programmatically, then remove it */
			if (items[i] instanceof ActionContributionItem) 
			{
				IAction action = ((ActionContributionItem)items[i]).getAction();
				String actionId = null;
				if (action != null && (actionId = action.getId()) != null && previoslyContributedItems.get(actionId) != null)
				{
					contributionManager.remove(items[i]);
					previoslyContributedItems.remove(actionId);
					continue;
				}
			}
			
			String itemId = items[i].getId();
			
			if (items[i] instanceof Separator)
				groups.put(itemId, Boolean.TRUE);
			else if (itemId != null)
				existingItems.put(itemId, Boolean.TRUE);
		}
		

		for (int i = 0; i < contributedControlItems.length; i++)
		{
			contributedControlItems[i].setEnabled(contributedControlItems[i].isEnabled());	
			if (!(contributionManager instanceof IToolBarManager) || ((contributedControlItems[i].getId() != null && existingItems.get(contributedControlItems[i].getId()) == null) && !doesItemExist(contributionManager, contributedControlItems[i])))
			{
				contributionManager.markDirty();
				String groupName = contributedControlItems[i].getGroup();			
				if (groups.get(groupName) == null)
				{
					if (contributionManager instanceof IMenuManager)
						contributionManager.appendToGroup(INavigatorContribution.GROUP_ADDITIONS, new Separator(groupName));
					else if (contributionManager instanceof IToolBarManager)
						contributionManager.add(new Separator(groupName));
					
					groups.put(groupName, Boolean.TRUE);
				}		
				
				if (contributedControlItems[i] != null && contributedControlItems[i].getId() != null)
					previoslyContributedItems.put(contributedControlItems[i].getId(), contributedControlItems[i]);
				
				contributionManager.appendToGroup(groupName, contributedControlItems[i]);
			}
		}					
		
		if (contributionManager.isDirty())
			contributionManager.update(true);
	}

	private static boolean doesItemExist(IContributionManager contributionManager, IControlItem item)
	{
		IContributionItem[] items = contributionManager.getItems();
		IAction currentAction; 
		for (int i = 0; i < items.length; i++) 
		{
			currentAction = null;
			if (items[i] instanceof ActionContributionItem)
				currentAction = ((ActionContributionItem)items[i]).getAction();
			
			if (currentAction != null && currentAction.equals(item))
				return true;
		}
		
		return false;
	}
}
