/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import java.util.Iterator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;

/**
 * This is the control provider for the log agent discoverer agent
 * 
 * @author Ali Mehregani
 */
public class AgentDiscovererControlProvider extends AbstractAgentControlProvider
{
	/** The agent state modifier */
	private IAgentStateModifier agentStateModifier;
		
	public AgentDiscovererControlProvider()
	{
		agentStateModifier = new LogAgentStateModifier();
	}
	
    public IAgentStateModifier getAgentStateModifier()
	{
    	return agentStateModifier;
	}
    
    
    /**
     * Overwrite this method so that it can be excluded from 
     * the options displayed to the user
     */
    protected IControlItem createAttachControlItem()
    {
    	return null;
    }

    
    /**
     * Overwrite this method so that it can be excluded from the
     * options displayed to the user.
     */
    protected IControlItem createDetachControlItem()
    {
    	return null;
    }

    
    /**
     * Overwrite this method so that it can be excluded from the
     * options displayed to the user.
     */
    protected IControlItem createPropertiesControlItem()
    {
    	return null;
    }
    
    
    /**
     * The state modifier for the log agent discoverer agent.
     * 
     * @author Ali Mehregani
     */
    protected static class LogAgentStateModifier implements IAgentStateModifier
    {
    	/** The input */
    	private StructuredSelection input;
    	
		public void detach() throws CoreException
		{
			/* doesn't need to be implemented */
		}

		public void attach() throws CoreException
		{
			/* doesn't need to be implemented */
		}

		
		/**
		 * Invoked when the user starts monitoring the agent.
		 */
		public void startMonitoring() throws CoreException
		{
			changeAgentState (true);
		}

		
		private void changeAgentState(boolean monitor)
		{
			/* The log agent discoverer agent is a dummy agent that isn't 
			 * affiliated with an execution agent */
			for (Iterator agents = input.iterator(); agents.hasNext();) 
				doAction ((TRCAgentProxy)agents.next(), monitor);			
		}
		
		/**
		 * Apply the action to the agent proxy that is passed in
		 * 
		 * @param agentProxy The agent proxy that the action should be applied to
		 */
		private void doAction(TRCAgentProxy agentProxy, boolean monitor) 
		{			
			agentProxy.setMonitored(monitor);
			agentProxy.setAttached(true);
			agentProxy.setActive(true);
						
			ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
			event.setSource(agentProxy);
			
			if (monitor)
				event.setType(ProfileEvent.START_MONITOR);
			else
				event.setType(ProfileEvent.STOP_MONITOR);
			
			UIPlugin.getDefault().notifyProfileEventListener(event);
		}

		public void pauseMonitoring() throws CoreException
		{
			changeAgentState (false);			
		}

		public boolean canAttach()
		{			
			return false;
		}

		public boolean canDetach()
		{			
			return false;
		}

		public boolean canPause()
		{
			return isOptionEnabled (true);
		}

		public boolean canResume()
		{
			return isOptionEnabled (false);
		}

		
		
		private boolean isOptionEnabled (boolean monitor)
		{
			TRCAgentProxy agentProxy;
			boolean isEnabled = true;
			for (Iterator agents = input.iterator(); isEnabled && agents.hasNext();) 
			{
				Object element = agents.next();				
				/* Apply the action only if the agent is an agent discoverer */
				isEnabled = 
					isEnabled && 
					element instanceof TRCAgentProxy && 															// It's an agent
					(agentProxy = (TRCAgentProxy)element).isActive() &&												// Agent is active
					agentProxy.isMonitored() == monitor;															// The state is right
			}

			return isEnabled;
		}
		
		
		public void setInput(StructuredSelection input)
		{
			this.input = input;			
		}
    	
    }
    
    
}
