/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import org.eclipse.hyades.log.ui.internal.OpenLogAgentWizard;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.tptp.trace.ui.internal.control.provider.ControlProviderManager;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.StandardAgentStateModifier;


/**
 * The log agent control provider 
 * 
 * @author Ali Mehregani
 */
public class LogAgentControlProvider extends AbstractAgentControlProvider
{
	/** The agent state modifier */
	private IAgentStateModifier agentStateModifier;
	
	/** The properties control item */
	private ControlItemAdapter properties;
	
	public LogAgentControlProvider()
	{
		agentStateModifier = new StandardAgentStateModifier();
	}
	
	public IAgentStateModifier getAgentStateModifier()
	{
		return agentStateModifier;
	}
	
    protected IControlItem createPropertiesControlItem()
    {
    	if (properties != null)
    		return properties;
    	
    	String entity = getEntity();
    	if (entity.equals(ControlProviderManager.PROCESS_ENTITY))
    		properties = new ControlItemAdapter(INavigatorContribution.GROUP_PROPERTIES, 
    				new OpenWizardAction((PDProjectExplorer)TraceControlItemManager.getNavigator(),
    					OpenProcessWizard.class,
    					UIPlugin.getResourceString(TraceMessages.PROP)));
    	else if (entity.equals(ControlProviderManager.AGENT_ENTITY))
    		properties = new ControlItemAdapter(INavigatorContribution.GROUP_PROPERTIES, 
    				new OpenWizardAction((PDProjectExplorer)TraceControlItemManager.getNavigator(),
    					OpenLogAgentWizard.class,
						UIPlugin.getResourceString(TraceMessages.PROP)));
    		    	
    	return properties;
    }

}
