/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentToolbarProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.StandardAgentStateModifier;

/**
 * The toolbar provider for log agents
 * 
 * @author Ali Mehregani
 */
public class LogAgentToolbarProvider extends AbstractAgentToolbarProvider
{
	/** The agent state modifier */
	private IAgentStateModifier agentStateModifier;
	
	
	public LogAgentToolbarProvider()
	{
		agentStateModifier = new StandardAgentStateModifier();
	}
	
	
	public IAgentStateModifier getAgentStateModifier()
	{
		return agentStateModifier;
	}

}
