/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.PIAgentControlProvider.GCControlItem;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.PIAgentControlProvider.HeapDumpControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentToolbarProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.StandardAgentStateModifier;

/**
 * The toolbar provider for the PI agents
 * @author Ali Mehregani
 */
public class PIAgentToolbarProvider extends AbstractAgentToolbarProvider
{
	/** The ids of the contributed items */
	public static final String GC_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.runGC";
	public static final String HEAP_DUMP_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.collectObjRef";
	
	/** The agent state modifier */
	private IAgentStateModifier agentStateModifier;
	
	/** The collect object reference control item */
	private IControlItem dumpHeapControlItem;
	
	/** The garbage collection control item */
	private IControlItem garbageCollectionControlItem;
	
	
	public PIAgentToolbarProvider()
	{
		agentStateModifier = new StandardAgentStateModifier();
	}
	
	
	public IAgentStateModifier getAgentStateModifier() 
	{
		return agentStateModifier;
	}
	
    protected void initializeControlItems()
	{
    	super.initializeControlItems();    	
    	addControlItem(createHeapDumpControlItem());
    	addControlItem(createGCControlItem());
	}
	
	protected IControlItem createGCControlItem()
	{
		if (garbageCollectionControlItem != null)
			return garbageCollectionControlItem;
		
		garbageCollectionControlItem = makeToolbarReady(new GCControlItem(), GC_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_GC_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_GC));
		return garbageCollectionControlItem;
	}
	
	protected IControlItem createHeapDumpControlItem()
	{
		if (dumpHeapControlItem != null)
			return dumpHeapControlItem;
		
		dumpHeapControlItem = makeToolbarReady(new HeapDumpControlItem(), HEAP_DUMP_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_GC_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_DUMP));
		return dumpHeapControlItem;
	}

}
