/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterExtendedConfigurationPage.java,v 1.1 2006/09/21 19:19:40 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersExtendedUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class FilterExtendedConfigurationPage extends FilterConfigurationPage {
	public FilterExtendedConfigurationPage() {
		super();
	}

	public FilterExtendedConfigurationPage(final String attributeName) {
		super(attributeName);
	}

	public Vector getAttributes() {
		Vector result = super.getAttributes();			
		String defaultValue = Boolean.valueOf(((TraceProfileFiltersExtendedUI)getFilterUI()).getAutoFilterCriteria()).toString();
		result.addElement(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, defaultValue));
		return result;
	}

	public boolean storeAttributes(final ILaunchConfigurationWorkingCopy workingCopy)
	{
		boolean autoFilterCriteria = ((TraceProfileFiltersExtendedUI)getFilterUI()).getAutoFilterCriteria();
		workingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, autoFilterCriteria);
		return super.storeAttributes(workingCopy);
	}

	public void createControl(final Composite parent) {
		super.createControl(parent);

		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean autoFilteringCriteriaValue = false;
		try {
			autoFilteringCriteriaValue = getLaunchConfiguration().getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, store.getBoolean(TraceConstants.AUTO_FILTER_CRITERIA_OPTION));
		} catch (CoreException e) {
			/* Don't need to do anything */
		}
		((TraceProfileFiltersExtendedUI)getFilterUI()).setAutoFilterCriteria(autoFilteringCriteriaValue);
	}

	protected TraceProfileFiltersUI createFilterUI() {
		return new TraceProfileFiltersExtendedUI();
	}
}
