/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDiscovererLaunchConfConstants.java,v 1.1 2006/03/08 19:03:09 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import org.eclipse.hyades.trace.ui.UIPlugin;

/**
 * Constants for storing profiling options/parameters in an <code>
 * ILaunchConfiguration</code>. All the data must be converted to string
 * form in order to persist after the workbench is shut down (no object
 * references allowed).
 * 
 * @see ILaunchConfiguration#getAttribute()
 * @see ILaunchConfiguration#setAttribute()
 * @author Ali Mehregani
 */
public interface IDiscovererLaunchConfConstants
{	
	/**
	 * A <code>int</code> storing the frequency check period for agents
	 */
	public static final String ATTR_OPT_FREQUENCY = UIPlugin.getPluginId() + IDiscovererLaunchConfConstants.class.getName() + ".ATTR_OPT_FREQUENCY";
	
	/**
	 * A <code>String</code> storing the filters.
	 */
	public static final String ATTR_FILTER = UIPlugin.getPluginId() + IDiscovererLaunchConfConstants.class.getName() + ".ATTR_FILTER";

}
