/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration.IExtendedConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;
import org.eclipse.ui.PlatformUI;

/**
 * Class created for defect 194939 in order to implement a UI option
 * to keep track of whether or not to enable auto-attach for profiling
 * launch configurations. 
 * Liz D.
 */
public class LimitsConfigurationPage implements IExtendedConfigurationPage, SelectionListener{
	
	/* To keep track of the attributes which we are assigning to track whether auto attach is enabled or disabled*/
	private String attributeName = IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING;
	/*The Launch Configuration we are working on */
	private ILaunchConfiguration launchconfiguration;
	/* A UI Grouping to keep track of the auto attach option */
	private Composite _monitoringGroup;
	/* The button (check box) which is by default checked and represents whether auto attach is on or off */
	private Button _autoMonitoring;
	/* The label for this section */
	private Label _monitoringDesp;
	/* Cache of user selection */
	private boolean _autoMonitor;
	
	
	public LimitsConfigurationPage()
	{
		this(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING);
	}
	public LimitsConfigurationPage(String attribute)
	{
		attributeName = attribute;
	}
	public String getTitle()
	{
		return LauncherMessages.CONFIGURATION_LIMIT_TITLE;
	}
	
	public ImageDescriptor getWizardBanner()
	{
		return TraceUIImages.INSTANCE.getImageDescriptor(TraceUIImages.IMG_PROF_SET_WIZ_BAN);
	}
	/**
	 * We will want to eventually share this dialog between the PI and TI cases and thus I have 
	 * included commented out code to create the entire dialog by re-using the PI dialog.
	 * The storeAttributes() and getAttributes() methods should remain independent
	 * code taken from TraceProfileCollectionsUI.java
	 * 
	 */
	public void createControl(Composite parent)
	{
		// once the remaining TI limit profiling options are implemented we can just call the commented out section below
		//TraceProfileCollectionsUI traceUI= new TraceProfileCollectionsUI();
		//traceUI.createControl(parent);
		addMonitorOption(parent);
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_autoMonitoring, UIPlugin
				.getPluginId()
				+ ".tlmt0003");
		
	}
	
	/**
	 * Adds the UI Monitoring Group Option. This code will be removed when we share this dialog between both types.
	 * code taken from TraceProfileCollectionsUI.java
	 * @param parent
	 */
	private void addMonitorOption(Composite parent) {
		_monitoringGroup = new Composite(parent, SWT.NULL);
		GridData data = GridUtil.createHorizontalFill();
		//data.horizontalSpan = 2;
		_monitoringGroup.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		_monitoringGroup.setLayout(layout);
	
		_autoMonitoring = new Button(_monitoringGroup, SWT.CHECK);
		_autoMonitoring.setText(
			UIPlugin.getResourceString(TraceMessages.AMONC));
		_autoMonitoring.setSelection(getLimitsValue());
		_autoMonitoring.addSelectionListener(this);
		_monitoringDesp = new Label(_monitoringGroup, SWT.NULL);
		_monitoringDesp.setText(
			UIPlugin.getResourceString(TraceMessages.AMONL));
		data = new GridData();
		data.horizontalIndent = 20;
		_monitoringDesp.setLayoutData(data);
		_monitoringDesp.setVisible(false);
		
		
		_autoMonitor = _autoMonitoring.getSelection();
	}
	
	
	/**
	 * Called whenever we finish the Edit Options Dialog for the current launch configuration
	 * This should store the value of the attributes as "org.eclipse.tptp.jvmti.client.ATTTR_AUTO_ATTACH" 
	 */ 
	public boolean storeAttributes(ILaunchConfigurationWorkingCopy launchConfig)
	{
		launchConfig.setAttribute(attributeName, _autoMonitoring.getSelection());
		_autoMonitor = _autoMonitoring.getSelection();
		return true;
	}
	
	/**
	 * This should return the current state of the attribute "org.eclipse.tptp.jvmti.client.ATTR_AUTO_ATTACH"
	 * it is a boolean attribute that defaults to true; 
	 */
	public Vector getAttributes()
	{
		Vector options = new Vector();
		options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, String.valueOf(_autoMonitor)));
		return options;
	}
	
	public String getPageName()
	{
		return LauncherMessages.CONFIGURATION_LIMIT_TITLE;
	}
	
	public String getDescription ()
	{
		return LauncherMessages.CONFIGURATION_LIMIT_DESC;
	}
	
	public void reset (ILaunchConfiguration config){
		launchconfiguration = config;
	}
	
	public void addErrorListener(IStatusListener status){
		// not yet implemented
	}
	
	
	public void widgetDefaultSelected(SelectionEvent event) 
	{
	
	}

	public void widgetSelected(SelectionEvent event) 
	{
	}

	/**
	 * A method to load the last saved value of the autoMonitoring field
	 * for this launchConfiguration, if one has been created
	 * @return the boolean value of the last saved selection (checked or unchecked)
	 * @throws CoreException if error occurs while getting the attribute
	 */
	public boolean getLimitsValue()
	{
		try
		{
			if (launchconfiguration!=null)
			{
				return launchconfiguration.getAttribute(attributeName, true);
			}
		}
		catch(CoreException e)
		{	
			CommonPlugin.logError(e);
		}
		return true;
	}
	
}
