/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration;

/**
 * Defines a non-editable configuration for the method coverage analysis type.
 * There are no editable options that the user can set for method coverage.
 *   
 * @author Ali Mehregani
 */
public class PIMethodCoverageConf implements ILightConfiguration
{
	/**
	 * Returns the profiling attributes that are understandable by
	 * the Agent controller.
	 */
	public DataCollectionEngineAttribute[] getAttributes()
	{
		List options = new ArrayList();

		String[][] flow = Options.OPTIONS_COVERAGE_NO_FLOW;
		for (int idx = 0; idx < flow.length; idx++) {
			options.add(new DataCollectionEngineAttribute(ILightConfiguration.AC_OPT_PREFIX_NAME + flow[idx][0], flow[idx][1]));
		}		
		
		DataCollectionEngineAttribute[] pOptions = new DataCollectionEngineAttribute[options.size()];
		options.toArray(pOptions);
		return pOptions;
	}

}
