/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import org.eclipse.core.runtime.IConfigurationElement;


/**
 * Represents an agent delcalarion.
 * @author Ali Mehregani
 */
public class AgentDeclaration
{
	/* The id of the agent */
	private String id;
	
	/* The name of the agent */
	private String name;
	
	/* The type of the agent */
	private String type;
	
	
	/**
	 * Constructor 
	 * @param id The id of the agent
	 * @param name The name of the agent
	 * @param type The type of the agent
	 */
	private AgentDeclaration(String id, String name, String type)
	{
		this.id = id;
		this.name = name;
		this.type = type;
	}
	
	/**
	 * Construct an instance of this class based on the configuration passed in.
	 * 
	 * @param element The element representing the declaration
	 * @return An instance of this class.
	 */
	public static AgentDeclaration constructInstance(IConfigurationElement element)
	{
		String[] attributeValues = LauncherUtility.getAttributes(element, new String[] {"id", "name", "type"});
		
		/* Ensure that all required fields are present */
		for (int i = 0; i < attributeValues.length; i++)
		{
			if (attributeValues[i] == null)
				return null;
		}
		
		
		return new AgentDeclaration (attributeValues[0], attributeValues[1], attributeValues[2]);
	}

	
	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getId()
	{
		return id;
	}
	
}
