/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class AgentDeclarationManager
{
	private static AgentDeclarationManager agentDeclarationMgr;
	private Hashtable agentDeclarations;
	
	/**
	 * Hide the constructor
	 */
	private AgentDeclarationManager()
	{
		agentDeclarations = new Hashtable();
		initialize();
	}

	/**
	 * Return the instance of this singleton class.
	 * 
	 * @return An instance of this class
	 */
	public static AgentDeclarationManager getInstance()
	{
		if (agentDeclarationMgr == null)
			agentDeclarationMgr = new AgentDeclarationManager();
		
		return agentDeclarationMgr;
	}
	
	
	private void initialize()
	{
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(
			"org.eclipse.hyades.trace.ui.agentDeclaration");
		
		for (int i = 0; i < elements.length; i++)
		{
			if (!"agent".equalsIgnoreCase(elements[i].getName()))
				continue;
			
			AgentDeclaration agentDeclaration = AgentDeclaration.constructInstance(elements[i]);
				
			if (agentDeclaration != null)
				agentDeclarations.put(agentDeclaration.getId(), agentDeclaration);
			
		}
	}
	
	public AgentDeclaration getAgentDeclaration(String agentDeclarationId)
	{
		return (AgentDeclaration)agentDeclarations.get(agentDeclarationId);
	}

	
	/**
	 * Given an agent name and type, find the corresponding declaration id (if it exists).
	 * @param agentName The agent name
	 * @param agentType The agent type
	 * @return The agent declaration id corresponding to the name and type passed in
	 */
	public String getAgentDeclarationId(String agentName, String agentType)
	{
		Enumeration agentDeclarationIds = agentDeclarations.keys();
		while (agentDeclarationIds.hasMoreElements())
		{
			String currentDeclarationId = (String)agentDeclarationIds.nextElement();
			AgentDeclaration ad = (AgentDeclaration) agentDeclarations.get(currentDeclarationId);
			if ((ad.getName().equals("*") || ad.getName().equals(agentName)) && (ad.getType().equals(agentType)))
				return currentDeclarationId;
		}
		
		return null;
	}
}
