/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.ArrayList;
import java.util.Hashtable;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/**
 * Loads the extension point org.eclipse.hyades.trace.ui.analysisTypesAssociation. 
 * 
 * @author Ali Mehregani
 */
public class AnalysisTypeAssociationManager 
{
	/**
	 * Keeps track of the associated analysis types of a data collector.
	 * KEY = Id of the data collector
	 * VALUE = An array list of analysis type ids
	 */
	private Hashtable associatedAnalysisTypes;
	
	/** The instance of this singleton class */
	private static AnalysisTypeAssociationManager instance;
	
	
	/**
	 * Hide the constructor
	 */
	private AnalysisTypeAssociationManager()
	{
		associatedAnalysisTypes = new Hashtable();
		initialize();
	}
	
	
	/**
	 * Performs the neccessary initializations.
	 */
	private void initialize() 
	{
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(
			"org.eclipse.hyades.trace.ui.analysisTypesAssociation");

		/* For every association element */
		for (int i = 0; i < elements.length; i++)
		{
			/* Get the data collector id */
			String dataCollectorId = elements[i].getAttribute("dataCollectionMechanismId");
			if (dataCollectorId == null)
				continue;
			
			/* For every analysis type element */
			IConfigurationElement[] analysisTypes = elements[i].getChildren();
			for (int j = 0; j < analysisTypes.length; j++)
			{
				String analysisTypeId;
				if ("analysisType".equals(analysisTypes[j].getName()) && (analysisTypeId = analysisTypes[j].getAttribute("id")) != null)
				{
					ArrayList analysisTypesList = (ArrayList)LauncherUtility.getHashtableEntry(associatedAnalysisTypes, dataCollectorId, ArrayList.class, true);
					analysisTypesList.add(analysisTypeId);
				}
			}
		}
	}
	
	
	/**
	 * Returns the single instance of this class
	 * 
	 * @return The instance of this class
	 */
	public static AnalysisTypeAssociationManager getInstance() 
	{
		if (instance == null)
			instance = new AnalysisTypeAssociationManager();
		return instance;
	}
	
	public AnalysisType[] getAssociatedAnalysisTypes (String dataCollectionMechanismId)
	{
		ArrayList analysisTypesList = new ArrayList();
		ArrayList analysisTypeIds = (ArrayList)associatedAnalysisTypes.get(dataCollectionMechanismId);
		if (analysisTypeIds != null)
		{
			for (int i = 0, analysisTypeCount = analysisTypeIds.size(); i < analysisTypeCount; i++)
			{
				AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType((String)analysisTypeIds.get(i));
				if (analysisType != null)
					analysisTypesList.add(analysisType);
			}
		}
		
		AnalysisType[] associatedTypes = new AnalysisType[analysisTypesList.size()];
		analysisTypesList.toArray(associatedTypes);
		return associatedTypes;
	}

}
