/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/**
 * Manager of the analysis types.  It scans for the analysis type extensions and will
 * register them with this manager.
 * 
 * @author Ali Mehregani
 */
public class AnalysisTypeManager
{
	private static AnalysisTypeManager instance;
	private Hashtable analysisTypes;
	
	private AnalysisTypeManager()
	{
		analysisTypes = new Hashtable();
		initialize();
	}
	
	
	private void initialize()
	{
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(
			"org.eclipse.hyades.trace.ui.analysisTypes");

		for (int i = 0; i < elements.length; i++)
		{
			AnalysisType analysisType = AnalysisType.constructInstance(elements[i]);
			analysisTypes.put(analysisType.getId(), analysisType);
		}
	}

	public static AnalysisTypeManager getInstance()
	{
		if (instance == null)
			instance = new AnalysisTypeManager();
		
		return instance;
	}

	public AnalysisType getAnalysisType(String analysisTypeId)
	{
		return (AnalysisType)analysisTypes.get(analysisTypeId);
	}

	
	/**
	 * Returns all registered analysis types.
	 * 
	 * @return A hashtable with KEY = analysis type ID, and VALUE = analysis type
	 */
	public Hashtable getAnalysisTypes()
	{
		return analysisTypes;
	}
}
