/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.trace.ui.provisional.launcher.IAvailabilityTester;
/**
 * A singleton class that delegates the task of testing the availability 
 * of a service to the tester that is registered.
 * 
 * @author Ali Mehregani
 */
public class AvailabilityTesterDelegate extends SelectionAdapter
{
	/* The instance of this class */
	private static AvailabilityTesterDelegate instance;
	
	/**
	 * Hide the visibility of this constructor.
	 */
	private AvailabilityTesterDelegate()
	{
	}
	
	
	/**
	 * Returns an instance of this class
	 * @return The instance of this singleton class
	 */
	public static AvailabilityTesterDelegate getInstance()
	{
		if (instance == null)
			instance = new AvailabilityTesterDelegate();
		
		return instance;
	}

	
	/**
	 * Invoked when the button is clicked.
	 * 
	 * @param e Represetns the selection event.
	 */
	public void widgetSelected(SelectionEvent e)
	{
		Object launchConfiguration = e.widget.getData(LauncherConstants.LAUNCH_CONFIGURATION);
		Object confLoader = e.widget.getData(LauncherConstants.CONFIGURATION_LOADER);
		IAvailabilityTester tester = null;
		
		/* If any of the required fields are not available, then disable the button */
		if (!(launchConfiguration instanceof ILaunchConfiguration) || !(confLoader instanceof LightConfigurationLoader) || (tester = ((LightConfigurationLoader)confLoader).getAvailabilityTester()) == null)
		{
			((Button)e.widget).setEnabled(false);
			return;
		}
		
		tester.reset((ILaunchConfiguration)launchConfiguration);
		IStatus status = tester.isServiceAvailable();
		
		if (status == null)
			return;
		
		/* Open an error, warning, or an info dialog based on the status returned */
		int statusSeverity = status.getSeverity();		
		if (statusSeverity == IStatus.ERROR || statusSeverity == IStatus.WARNING)
			LauncherUtility.openMessageWithDetail(Display.getDefault().getActiveShell(), statusSeverity, 
					statusSeverity == IStatus.ERROR ? LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE : LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, 
					status.getMessage(), status.getException() != null ? status.getException().getMessage() : "");		
		else if (statusSeverity == IStatus.OK)
			MessageDialog.openInformation(Display.getDefault().getActiveShell(), LauncherMessages.LAUNCHER_COMMON_INFO_TITLE, status.getMessage());
		
	}

}
