/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/**
 * The manager for initializing and maintaining the configuration wizard contributions.
 *  
 * @author Ali Mehregani
 */
public class ConfigurationManager
{
	/* This instance of this singleton class */
	private static ConfigurationManager instance;
	
	/* Stores the configuration loaders. 
	 * KEY = configuration loader id.  
	 * VALUE = An instance of LightConfigurationLoader which can be 
	 * safely casted to ConfigurationLoader if LightConfigurationLoader.isEditable() == true */
	private Hashtable configurationLoaders;
	
	/**
	 * Hide the default constructor.
	 */
	private ConfigurationManager()
	{
		configurationLoaders = new Hashtable();
		initialize();
	}
	
	
	/**
	 * Scan the registered configuration wizards and associate them
	 * to data collectors or analysis types.
	 */
	private void initialize()
	{
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(
				"org.eclipse.hyades.trace.ui.configuration");
		
		/* Iterate through each configuration element to construct the configuration object
		 * and to associate it with the right entity. */
		for (int i = 0; i < elements.length; i++)
		{
			LightConfigurationLoader configurationLoader;
			
			/* Ignore the element if it's not a configuration element */
			if (!"configuration".equalsIgnoreCase(elements[i].getName()))
				continue;
			
			/* Construct a light configuration or an editable configuration depending on the editable fields */
			String editable = elements[i].getAttribute("editable");
			if (editable == null || "true".equalsIgnoreCase(editable))				
				configurationLoader = ConfigurationLoader.constructInstance(elements[i]);
			else
				configurationLoader = LightConfigurationLoader.constructInstance(elements[i]);
			
			if (configurationLoader == null)
				continue;
			
			configurationLoaders.put(configurationLoader.getId(), configurationLoader);
		}
	}


	/**
	 * Returns the instance of this singleton class.
	 * 
	 * @return The instance of htis singleton class
	 */
	public static ConfigurationManager getInstance()
	{
		if (instance == null)
			instance = new ConfigurationManager();
		return instance;
	}

	public LightConfigurationLoader getConfiguration(String configurationId)
	{
		return (LightConfigurationLoader)configurationLoaders.get(configurationId);
	}

}
